

import { TEXT_ALIGN, VERTICAL_ALIGN } from "../const";
import Texture from "../texture/Texture";
import { Sprite, Container } from "../display";

/**
 * 单位图字缓存
 */
const bitmapTextSinglePool: BitmapTextSingle[] = []

/**
 * 位图文字
 * 暂不做通用，以后再说，否则回收问题
 */
export class BitmapText extends Container {
    private textures: { [text: string]: Texture }
    /**
     * 水平对齐方式，默认居中
     * 改变x坐标原点
     */
    get textAlign() {
        return this._textAlign
    }
    set textAlign(value: TEXT_ALIGN) {
        if (this._textAlign !== value) {
            this._textAlign = value;
            this.adaptate();
        }
    }
    private _textAlign: TEXT_ALIGN = TEXT_ALIGN.CENTER;
    /**
     * 垂直居中方式，默认居中
     * 改变y坐标原点
     */
    get verticalAlign() {
        return this._verticalAlign
    }
    set verticalAlign(value: VERTICAL_ALIGN) {
        if (this._verticalAlign !== value) {
            this._verticalAlign = value;
            this.adaptate();
        }
    }
    private _verticalAlign: VERTICAL_ALIGN = VERTICAL_ALIGN.MIDDLE;
    /**
     * 文字间隙，为了有些文本不能紧贴（切图问题），可设置负数解决
     */
    get gap(): number {
        return this._gap;
    };
    set gap(value: number) {
        if (this._gap != value) {
            this._gap = value;
            this.adaptate();
        }
    };
    private _gap: number = 0;
    /**
     * 文本
     */
    private _text: string;
    get text(): string {
        return this._text
    }
    /**
     * 设置文本
     */
    set text(value: string) {
        let i;
	    if (value === this._text) return;
        this._text = value;
	    const arr = value || [];
        for (i = 0; i < arr.length; i++) {
            if (this.children[i]) {
                //先用完原先$children里的
                this.children[i]["text"] = arr[i];
            } else {
                //如果没有就
                let o: BitmapTextSingle = bitmapTextSinglePool.shift();
                if (!o) {
                    o = new BitmapTextSingle(this.textures);
                } else {
                    o.reset(this.textures)
                }
                o.text = arr[i];
                this.addChild(o)
            }
        }
        //如果多了，去掉后面的，回收
        if (this.children.length > arr.length) {
            //移除后序
            for (i = this.children.length - 1; i >= arr.length; i--) {
                let c = this.children[i] as BitmapTextSingle;
                this.removeChild(c);
                bitmapTextSinglePool.push(c);
            }
        }
        //适配
        this.adaptate();
    }
    /**
     *
     * @param textures 0到9的贴图
     */
    constructor(textures: { [text: string]: Texture }) {
        super();
        this.textures = textures;
    }

    /**
     * 适配，
     */
    private adaptate() {
        if (!this.children.length) return
        var len = this.children.length;
        //算总长度
        var sum = 0;
        for (var m = 0; m < len; m++) {
            sum += this.children[m].width;
        }
        sum += (len - 1) * this._gap;
        //算出左边第一个元素的位置
        var left: number;
        if (this._textAlign == TEXT_ALIGN.LEFT) {
            left = 0
        }
        else if (this._textAlign == TEXT_ALIGN.RIGHT) {
            left = -sum
        } else {
            left = -sum / 2
        }
        var temSum = 0;
        for (var i = 0; i < this.children.length; i++) {
            this.children[i].x = left + temSum
            temSum += this.children[i].width + this._gap;
        }
        //垂直居中，找出高度最大的图片
        // var maxH = 0;
        // for (var m = 0; m < len; m++) {
        //     maxH = Math.max(maxH, this.children[m].height)
        // }
        // var up: number;
        // if (this._verticalAlign == VERTICAL_ALIGN.UP) {
        //     up = 0
        // }
        // else if (this._verticalAlign == VERTICAL_ALIGN.DOWN) {
        //     up = -maxH
        // } else {
        //     up = -maxH / 2
        // }
        // for (var i = 0; i < this.children.length; i++)this.children[i].y = up;
        var up: number = 0;
        if (this._verticalAlign == VERTICAL_ALIGN.DOWN) {
            up = -1;
        } else if (this._verticalAlign == VERTICAL_ALIGN.MIDDLE) {
            up = -1 / 2;
        }
        this.children.forEach((c) => {
            c.y = c.height * up;
        })
    }
}


/**
 * 位图字，单个
 */
class BitmapTextSingle extends Sprite {
    /**
     * 文字表
     */
    private textures: {
        [text: string]: Texture
    };
    /**
     * 单字
     */
    private _text: string;
    get text(): string {
        return this._text
    }
    set text(value: string) {
        // if (value == this._text) return;
        this._text = value;
        this.texture = this.textures[this._text];
    }

    /**
     *
     * @param textures 贴图表，{"0":texture1,"1":texture2,".":texture3}
     */
    constructor(textures: { [text: string]: Texture }) {
        super();
        this.textures = textures;
    }

    /**
     * 替换资源，基本不用吧应该
     * @param textures
     */
    reset(textures: { [text: string]: Texture }) {
        this.textures = textures
    }
}
