/**
 * filter模块基本延用pixi模块
 * {@link http://pixijs.io/pixi-filters/tools/demo/}
 * This namespace contains WebGL-only display filters that can be applied
 * to DisplayObjects using the {@link DisplayObject#filters filters} property.
 * @example

 * // Draw a green rectangle
 * const rect = new Graphics()
 *     .beginFill(0x00ff00)
 *     .drawRect(40, 40, 200, 200);
 *
 * // Add a blur filter
 * rect.filters = [new filters.BlurFilter()];
 *
 * 耗性能得很，毕竟要建帧缓存和增加着色器计算负担
 * 1、避免滤镜嵌套
 * 2、修改屏幕分辨率，为了减小画布
 * 3、滤镜范围越大越卡（滤镜宿主需渲染的大小，像素透明度不为0的范围大小）
 * 4、sprite遮罩性能比Graphics差（能用Graphics就用Graphics），暂时只有刮刮卡需要
 * 5、暂时发现BlurFilter性能很差，着色器多次运行处理帧缓存，建议使用新的BlurFilterNew
 * 6、noise在移动端还有点问题，无效果，且变暗
 * 7
 */
export { default as Filter } from './Filter';
export { default as FXAAFilter } from './fxaa/FXAAFilter';
export { default as NoiseFilter } from './noise/NoiseFilter';
export { default as DisplacementFilter } from './displacement/DisplacementFilter';
export { default as BlurFilter } from './blur/BlurFilter';
export { default as BlurXFilter } from './blur/BlurXFilter';
export { default as BlurYFilter } from './blur/BlurYFilter';
export { default as ColorMatrixFilter } from './colormatrix/ColorMatrixFilter';
export { default as AlphaFilter } from './alpha/AlphaFilter';
export { default as SpriteMaskFilter } from './spriteMask/SpriteMaskFilter';

export { default as BlurFilterNew } from './blur/BlurFilterNew';

export * from './advanced-bloom/AdvancedBloomFilter';
