import { Object3D } from "../Object3D";
import { Vector3 } from "../math/Vector3";
import { rgb2hex, hex2rgb } from "../../2d/utils";
import { LightShadow } from "./LightShadow";

/**
 * 光源基类，只有颜色和光源强度
 */
export class Light extends Object3D {

    private _color: number = 0xffffff;
    private _colorArr: Float32Array = new Float32Array([1.0, 1.0, 1.0]);
    private _colorVec3: Vector3 = new Vector3(1.0, 1.0, 1.0);
    get color() {
        return this._color;
    }
    set color(value: number) {
        if (this._color === value) return;
        this._color = value;
        var arr = hex2rgb(value)
        this._colorArr[0] = this._colorVec3.x = arr[0];
        this._colorArr[1] = this._colorVec3.y = arr[1];
        this._colorArr[2] = this._colorVec3.z = arr[2];
    }
    //获取
    get colorArr() {
        return this._colorArr;
    }
    get colorVec3() {
        return this._colorVec3;
    }

    /**
     * 阴影。为了阴影贴图
     */
    shadow: LightShadow
    /**
     * 
     * @param color rgb三分量的矢量，每个分量0到1，颜色方面后续优化
     * @param intensity 光照强度 0到1 ,直接影响颜色值，不进uniform
     */
    constructor(
        color: number,
        public intensity: number = 1
    ) {
        super();
        this.color = color;
        this._instanceType = "Light"
    }
    copy(light: Light) {
        super.copy(light);
        this.color = light.color;
        this.intensity = light.intensity;
        this.shadow = light.shadow.clone();
        return this
    }
}