import { SHAPES } from "../../const";
import GraphicsData from "../GraphicsData";
import Graphics from "../Graphics";



/**
 * Builds a circle to draw
 *
 * Ignored from docs since it is not directly exposed.
 *
 * @ignore
 * @private
 * @param {WebGLGraphicsData} graphicsData - The graphics object to draw
 * @param {object} webGLData - an object containing all the WebGL-specific information to create this shape
 * @param {object} webGLDataNativeLines - an object containing all the WebGL-specific information to create nativeLines
 */
export default {

    build(graphicsData: GraphicsData) {
        // need to convert points to a nice regular data
        const circleData = graphicsData.shape;
        const points = graphicsData.points;
        const x = circleData.x;
        const y = circleData.y;
        let width;
        let height;

        points.length = 0;

        // TODO - bit hacky??
        if (graphicsData.type === SHAPES.CIRC) {
            width = circleData.radius;
            height = circleData.radius;
        }
        else {
            width = circleData.width;
            height = circleData.height;
        }

        if (width === 0 || height === 0) {
            return;
        }

        let totalSegs = Math.floor(30 * Math.sqrt(circleData.radius))
            || Math.floor(15 * Math.sqrt(width + height));

        totalSegs /= 2.3;

        const seg = (Math.PI * 2) / totalSegs;

        // for (let i = 0; i < totalSegs; i++) {
        //     points.push(
        //         x + (Math.sin(seg * i) * width),
        //         y + (Math.cos(seg * i) * height)
        //     );
        // }
        //20211220修改
        for (let i = 0; i < totalSegs - 0.5; i++) {
            points.push(//顺时针
                x + (Math.cos(seg * i) * width),
                y + (Math.sin(seg * i) * height)
            );
        }

        points.push(
            points[0],
            points[1]
        );
    },

    triangulate(graphicsData, graphicsGeometry: Graphics) {
        const points = graphicsData.points;
        const verts = graphicsGeometry.verts;
        const indices = graphicsGeometry.indices;

        let vertPos = verts.length / 2;
        const center = vertPos;

        verts.push(graphicsData.shape.x, graphicsData.shape.y);

        for (let i = 0; i < points.length; i += 2) {
            verts.push(points[i], points[i + 1]);

            // add some uvs
            indices.push(vertPos++, center, vertPos);
        }
    },
};
