import { Attachment } from "./attachment/Attachment";
import { Slot } from "./Slot";

export class Skin {
    attachments = new Array();
    constructor(public name: string) {
    }
    addAttachment(slotIndex: number, name: string, attachment: Attachment) {
        var attachments = this.attachments;
        if (slotIndex >= attachments.length)
            attachments.length = slotIndex + 1;
        if (!attachments[slotIndex])
            attachments[slotIndex] = {};
        attachments[slotIndex][name] = attachment;
    };
    getAttachment(slotIndex: number, name: string) {
        var dictionary = this.attachments[slotIndex];
        return dictionary ? dictionary[name] : null;
    };
    attachAll(slots: Slot[], oldSkin: Skin) {
        var slotIndex = 0;
        for (var i = 0; i < slots.length; i++) {
            var slot = slots[i];
            var slotAttachment = slot.getAttachment();
            if (slotAttachment && slotIndex < oldSkin.attachments.length) {
                var dictionary = oldSkin.attachments[slotIndex];
                for (var key in dictionary) {
                    var skinAttachment = dictionary[key];
                    if (slotAttachment == skinAttachment) {
                        var attachment = this.getAttachment(slotIndex, key);
                        if (attachment != null)
                            slot.setAttachment(attachment);
                        break;
                    }
                }
            }
            slotIndex++;
        }
    };
}
