import { GLShader } from "../../glCore";

//着色器变量统一驼峰
const baseVert = [
    "attribute vec4 aPosition;",//顶点位置信息
    "attribute vec4 aColor;",//顶点颜色数据
    "uniform mat4 uViewMatrix;",//视图矩阵，camera的worldMatrixInverse
    "uniform mat4 uProjectionMatrix;",//投影矩阵，camera的projectionMatrix
    // "uniform mat4 u_vpMatrix;",//p*v的矩阵由于放在相机上，就一起了
    "uniform mat4 uModelMatrix;",//模型矩阵

    "varying vec4 vColor;",//只有颜色数据需要传，或者考虑是否放材质里

    "void main() {",
    "gl_Position = uProjectionMatrix * uViewMatrix * uModelMatrix * aPosition;",
    "vColor = aColor;",
    "}"
].join("\n")


const baseFrag = [
    "precision mediump float;",//片元得加精度
    "varying vec4 vColor;",//考虑颜色谁传
    "void main() {",
    "gl_FragColor = vColor;",
    "}"
].join("\n")


/**
 * 着色器程序根据渲染器的uid和着色器的字符或者自己的id缓存，
 * 以后按照材质参数拼着色器
 * 纯色的，不带光照的，不带贴图的着色器，估计很少会用，至少也得带贴图的吧
 */
export class BaseShader extends GLShader {
    /**
     * 作为该着色器的标识
     */
    _glShaderKey: string;
    constructor(gl: WebGLRenderingContext) {
        super(gl, baseVert, baseFrag)
        this._glShaderKey = "BaseShader";
    }
}