const resolve = require('rollup-plugin-node-resolve');
const commonjs = require('rollup-plugin-commonjs');
const progress = require('rollup-plugin-progress');
const typescript = require('rollup-plugin-typescript');
const { terser } = require('rollup-plugin-terser');
const livereload = require('rollup-plugin-livereload');
const serve = require('rollup-plugin-serve');

// const fs = require('fs');

//rollup-plugin-typescript里有tslib
//const tslibWrapper = 'var tslib = {__extends: __extends,__assign: __assign,__rest: __rest,__decorate: __decorate,__param: __param,__metadata: __metadata,__awaiter: __awaiter,__generator: __generator,__exportStar: __exportStar,__values: __values,__read: __read,__spread: __spread,__spreadArrays: __spreadArrays,__await: __await,__asyncGenerator: __asyncGenerator,__asyncDelegator: __asyncDelegator,__asyncValues: __asyncValues,__makeTemplateObject: __makeTemplateObject,__importStar: __importStar,__importDefault: __importDefault};'
//const tslibCode = fs.readFileSync(__dirname + '/scripts/tslib.min.js');

const isProd = process.env.BUILD === 'production';

import pkg from "./package.json";

const version = pkg.version;
const outputPath = isProd ? "build" : "debug";

const plugins = [
  progress(),
  resolve(),
  typescript(),
  commonjs(),
  isProd && terser(),
  !isProd && livereload(),
];

export default [
  {
    input: 'src/index.ts',
    output: [
      {
        file: `${outputPath}/fyge_${version}.min.js`,
        format: 'umd',
        name: 'FYGE',
        sourcemap: true//!isProd,
      },
      {
        file: `${outputPath}/fyge_${version}.esm.js`,
        format: 'esm',
        sourcemap: true//!isProd,
      }
    ],
    plugins: [
      ...plugins,
      !isProd && serve({
        port: 8099,
        headers: {
          'Access-Control-Allow-Origin': '*',
        },
      }),
    ],
  },
  {
    input: 'src/2d.ts',
    output: [
      {
        file: `${outputPath}/fyge2d_${version}.min.js`,
        format: 'umd',
        name: 'FYGE',
        sourcemap: true//!isProd,
      },
      {
        file: `${outputPath}/fyge2d_${version}.esm.js`,
        format: 'esm',
        sourcemap: true//!isProd,
      }
    ],
    plugins: plugins,
  }
];
