import { getBezierEasing } from "./BezierEaser";


export function buildBezierEaserProps(
    startValue: number[],
    endValue: number[],
    outV,
    inV,
    startIndex: number,
    endIndex: number,
    points,
    useH:boolean,
    limit?: number
) {
    if(useH){
        for (var k = startIndex; k < endIndex; k++) {//这时不算最后一个
            points[k] = startValue.slice();
        }
        return
    }


    var outX, outY, inX, inY, keyValue, perc;
    var len = startValue.length;

    var fncts, fnc;
    if (outV.x.constructor === Array) {
        fncts = [];
        for (var i = 0; i < len; i++) {
            outX = (typeof outV.x[i] === 'undefined') ? outV.x[0] : outV.x[i];
            outY = (typeof outV.y[i] === 'undefined') ? outV.y[0] : outV.y[i];
            inX = (typeof inV.x[i] === 'undefined') ? inV.x[0] : inV.x[i];
            inY = (typeof inV.y[i] === 'undefined') ? inV.y[0] : inV.y[i];
            fncts[i] = getBezierEasing(outX, outY, inX, inY).get;
        }
    } else {
        outX = outV.x;
        outY = outV.y;
        inX = inV.x;
        inY = inV.y;
        fnc = getBezierEasing(outX, outY, inX, inY).get;
    }
    var delta = endIndex - startIndex
    for (var k = startIndex; k <= endIndex; k++) {
        if (limit) {
            //小于0的不算了，浪费时间
            if (k < 0) continue;
            //超出的也不要了
            if (k >= limit) break;//遇到那种
        }
        var frameNum = k;
        var newValue = [];
        for (var i = 0; i < len; i += 1) {
            if (frameNum == endIndex) {
                perc = 1;
            } else if (frameNum == startIndex) {
                perc = 0;
            } else {
                if (fncts) {
                    perc = fncts[i]((frameNum - startIndex) / delta);
                } else {
                    perc = fnc((frameNum - startIndex) / delta);
                }
            }
            keyValue = startValue[i] + (endValue[i] - startValue[i]) * perc;
            newValue[i] = keyValue;
        }
        points[k] = newValue
    }
}