
import { Object3D } from '../Object3D';
import { Light } from './Light';
import { Vector3 } from '../math/Vector3';
import { DirectionalLightShadow } from './DirectionalLightShadow';




export class DirectionalLight extends Light {
	/**
	 * 目标对象
	 */
	target: Object3D;

	constructor(color: number, intensity: number) {
		super(color, intensity)
		this._instanceType = "DirectionalLight";
		//位置默认一个
		this.position.copy(Object3D.DefaultUp);
		// this.updateMatrix();
		this.updateLocalMatrix();
		//目标默认一个，算方向用
		this.target = new Object3D();

		this.shadow = new DirectionalLightShadow();
	}
	copy(directionalLight: DirectionalLight) {
		super.copy(directionalLight);
		this.target = directionalLight.target.clone();
		return this
	}

}
