import { Light } from "./Light";
import { Vector3 } from "../math/Vector3";




export class PointLight extends Light {
    /**
     * 
     * @param color 颜色值，0到1的矢量
     * @param intensity 强度
     * @param distance 最大影响距离
     * @param decay 衰减系数，//多试试2
     */
    constructor(
        color: number,
        intensity: number,
        public distance: number = 0,
        public decay: number = 1
    ) {
        super(color, intensity);
        this._instanceType = "PointLight";
    }

    get power(): number {
        return this.intensity * 4 * Math.PI;
    }
    set power(value: number) {
        this.intensity = value / (4 * Math.PI);
    }
    copy(pointLight: PointLight) {
        super.copy(pointLight);
        this.distance = pointLight.distance;
        this.decay = pointLight.decay;
        return this
    }
}