declare namespace Tween{export class Ease {
    /**
     * @version
     * @platform Web,Native
     */
    constructor();
    /**
     * get.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * get。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static get(amount: number): (t: number) => number;
    /**
     * get pow in.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * get pow in。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static getPowIn(pow: number): (t: number) => number;
    /**
     * get pow out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * get pow out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static getPowOut(pow: number): (t: number) => number;
    /**
     * get pow in out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * get pow in out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static getPowInOut(pow: number): (t: number) => number;
    /**
     * quad in.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * quad in。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static quadIn: (t: number) => number;
    /**
     * quad out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * quad out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static quadOut: (t: number) => number;
    /**
     * quad in out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * quad in out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static quadInOut: (t: number) => number;
    /**
     * cubic in.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * cubic in。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static cubicIn: (t: number) => number;
    /**
     * cubic out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * cubic out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static cubicOut: (t: number) => number;
    /**
     * cubic in out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * cubic in out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static cubicInOut: (t: number) => number;
    /**
     * quart in.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * quart in。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static quartIn: (t: number) => number;
    /**
     * quart out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * quart out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static quartOut: (t: number) => number;
    /**
     * quart in out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * quart in out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static quartInOut: (t: number) => number;
    /**
     * quint in.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * quint in。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static quintIn: (t: number) => number;
    /**
     * quint out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * quint out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static quintOut: (t: number) => number;
    /**
     * quint in out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * quint in out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static quintInOut: (t: number) => number;
    /**
     * sine in.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * sine in。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static sineIn(t: number): number;
    /**
     * sine out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * sine out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static sineOut(t: number): number;
    /**
     * sine in out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * sine in out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static sineInOut(t: number): number;
    /**
     * get back in.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * get back in。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static getBackIn(amount: number): (t: number) => number;
    /**
     * back in.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * back in。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static backIn: (t: number) => number;
    /**
     * get back out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * get back out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static getBackOut(amount: number): (t: any) => number;
    /**
     * back out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * back out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static backOut: (t: any) => number;
    /**
     * get back in out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * get back in out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static getBackInOut(amount: number): (t: number) => number;
    /**
     * back in out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * back in out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static backInOut: (t: number) => number;
    /**
     * circ in.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * circ in。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static circIn(t: number): number;
    /**
     * circ out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * circ out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static circOut(t: number): number;
    /**
     * circ in out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * circ in out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static circInOut(t: number): number;
    /**
     * bounce in.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * bounce in。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static bounceIn(t: number): number;
    /**
     * bounce out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * bounce out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static bounceOut(t: number): number;
    /**
     * bounce in out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * bounce in out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static bounceInOut(t: number): number;
    /**
     * get elastic in.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * get elastic in。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static getElasticIn(amplitude: number, period: number): (t: number) => number;
    /**
     * elastic in.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * elastic in。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static elasticIn: (t: number) => number;
    /**
     * get elastic out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * get elastic out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static getElasticOut(amplitude: number, period: number): (t: number) => number;
    /**
     * elastic out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * elastic out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static elasticOut: (t: number) => number;
    /**
     * get elastic in out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * get elastic in out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static getElasticInOut(amplitude: number, period: number): (t: number) => number;
    /**
     * elastic in out.See example.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * elastic in out。请查看示例
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static elasticInOut: (t: number) => number;
}

export class Tween {
    /**
     * 不做特殊处理
     * @constant {number} Tween.NONE
     * @private
     */
    private static NONE;
    /**
     * 循环
     * @constant {number} Tween.LOOP
     * @private
     */
    private static LOOP;
    /**
     * 倒序
     * @constant {number} Tween.REVERSE
     * @private
     */
    private static REVERSE;
    /**
     * @private
     */
    private static _tweens;
    /**
     * @private
     */
    private static IGNORE;
    /**
     * @private
     */
    private static _plugins;
    /**
     * @private
     */
    private static _inited;
    /**
     * @private
     */
    private _target;
    /**
     * @private
     */
    private _useTicks;
    /**
     * @private
     */
    private ignoreGlobalPause;
    /**
     * @private
     */
    private loop;
    /**
     * @private
     */
    private pluginData;
    /**
     * @private
     */
    private _curQueueProps;
    /**
     * @private
     */
    private _initQueueProps;
    /**
     * @private
     */
    private _steps;
    /**
     * @private
     */
    private paused;
    /**
     * @private
     */
    private duration;
    /**
     * @private
     */
    private _prevPos;
    /**
     * @private
     */
    private position;
    /**
     * @private
     */
    private _prevPosition;
    /**
     * @private
     */
    private _stepPosition;
    /**
     * @private
     */
    private passive;
    /**
     * Activate an object and add a Tween animation to the object
     * @param target {any} The object to be activated
     * @param props {any} Parameters, support loop onChange onChangeObj
     * @param pluginData {any} Write realized
     * @param override {boolean} Whether to remove the object before adding a tween, the default value false
     * Not recommended, you can use Tween.removeTweens(target) instead.
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * 激活一个对象，对其添加 Tween 动画
     * @param target {any} 要激活 Tween 的对象
     * @param props {any} 参数，支持loop(循环播放) onChange(变化函数) onChangeObj(变化函数作用域)
     * @param pluginData {any} 暂未实现
     * @param override {boolean} 是否移除对象之前添加的tween，默认值false。
     * 不建议使用，可使用 Tween.removeTweens(target) 代替。
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static get(target: any, props?: {
        loop?: boolean;
        onChange?: Function;
        onChangeObj?: any;
    }, pluginData?: any, override?: boolean): Tween;
    /**
     * Delete all Tween animations from an object
     * @param target The object whose Tween to be deleted
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * 删除一个对象上的全部 Tween 动画
     * @param target  需要移除 Tween 的对象
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static removeTweens(target: any): void;
    /**
     * 移除tween
     * @param tween get返回的Tween实例
     */
    static removeTweenSelf(tween: Tween): void;
    /**
     * Pause all Tween animations of a certain object
     * @param target The object whose Tween to be paused
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * 暂停某个对象的所有 Tween
     * @param target 要暂停 Tween 的对象
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static pauseTweens(target: any): void;
    /**
     * Resume playing all easing of a certain object
     * @param target The object whose Tween to be resumed
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * 继续播放某个对象的所有缓动
     * @param target 要继续播放 Tween 的对象
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static resumeTweens(target: any): void;
    /**
     * @private
     *
     * @param delta
     * @param paused
     */
    private static tick;
    /**
     * flush方法，为了能加入总循环
     * 默认是锁步的
     * @param delta
     * @param paused ,暂时不用，全局禁止
     */
    static flush(): void;
    private static _lastTime;
    /**
     * @private
     *
     * @param tween
     * @param value
     */
    private static _register;
    /**
     * Delete all Tween
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * 删除所有 Tween
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    static removeAllTweens(): void;
    /**
     * 创建一个 Tween 对象
     * @private
     * @version
     * @platform Web,Native
     */
    constructor(target: any, props: any, pluginData: any);
    onChange: Function;
    /**
     * @private
     *
     * @param target
     * @param props
     * @param pluginData
     */
    private initialize;
    /**
     * @private
     *
     * @param value
     * @param actionsMode
     * @returns
     */
    setPosition(value: number, actionsMode?: number): boolean;
    /**
     * @private
     *
     * @param startPos
     * @param endPos
     * @param includeStart
     */
    private _runAction;
    /**
     * @private
     *
     * @param step
     * @param ratio
     */
    private _updateTargetProps;
    /**
     * Whether setting is paused
     * @param value {boolean} Whether to pause
     * @returns Tween object itself
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * 设置是否暂停
     * @param value {boolean} 是否暂停
     * @returns Tween对象本身
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    setPaused(value: boolean): Tween;
    /**
     * @private
     *
     * @param props
     * @returns
     */
    private _cloneProps;
    /**
     * @private
     *
     * @param o
     * @returns
     */
    private _addStep;
    /**
     * @private
     *
     * @param o
     * @returns
     */
    private _appendQueueProps;
    /**
     * @private
     *
     * @param o
     * @returns
     */
    private _addAction;
    /**
     * @private
     *
     * @param props
     * @param o
     */
    private _set;
    /**
     * Wait the specified milliseconds before the execution of the next animation
     * @param duration {number} Waiting time, in milliseconds
     * @param passive {boolean} Whether properties are updated during the waiting time
     * @returns Tween object itself
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * 等待指定毫秒后执行下一个动画
     * @param duration {number} 要等待的时间，以毫秒为单位
     * @param passive {boolean} 等待期间属性是否会更新
     * @returns Tween对象本身
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    wait(duration: number, passive?: boolean): Tween;
    /**
     * Modify the property of the specified object to a specified value
     * @param props {Object} Property set of an object
     * @param duration {number} Duration
     * @param ease {Ease} Easing algorithm
     * @returns {Tween} Tween object itself
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * 将指定对象的属性修改为指定值
     * @param props {Object} 对象的属性集合
     * @param duration {number} 持续时间
     * @param ease {Ease} 缓动算法
     * @returns {Tween} Tween对象本身
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    to(props: any, duration?: number, ease?: Function): Tween;
    /**
     * by
     * @param props
     * @param duration
     * @param ease
     */
    by(props: any, duration?: number, ease?: Function): Tween;
    /**
     * Execute callback function
     * @param callback {Function} Callback method
     * @param thisObj {any} this action scope of the callback method
     * @param params {any[]} Parameter of the callback method
     * @returns {Tween} Tween object itself
     * @version
     * @platform Web,Native
     * @example
     * <pre>
     *  Tween.get(display).call(function (a:number, b:string) {
     *      console.log("a: " + a); // the first parameter passed 233
     *      console.log("b: " + b); // the second parameter passed “hello”
     *  }, this, [233, "hello"]);
     * </pre>
     * @language en_US
     */
    /**
     * 执行回调函数
     * @param callback {Function} 回调方法
     * @param thisObj {any} 回调方法this作用域
     * @param params {any[]} 回调方法参数
     * @returns {Tween} Tween对象本身
     * @version
     * @platform Web,Native
     * @example
     * <pre>
     *  Tween.get(display).call(function (a:number, b:string) {
     *      console.log("a: " + a); //对应传入的第一个参数 233
     *      console.log("b: " + b); //对应传入的第二个参数 “hello”
     *  }, this, [233, "hello"]);
     * </pre>
     * @language zh_CN
     */
    call(callback: Function, thisObj?: any, params?: any[]): Tween;
    /**
     * Now modify the properties of the specified object to the specified value
     * @param props {Object} Property set of an object
     * @param target The object whose Tween to be resumed
     * @returns {Tween} Tween object itself
     * @version
     * @platform Web,Native
     */
    /**
     * 立即将指定对象的属性修改为指定值
     * @param props {Object} 对象的属性集合
     * @param target 要继续播放 Tween 的对象
     * @returns {Tween} Tween对象本身
     * @version
     * @platform Web,Native
     */
    set(props: any, target?: any): Tween;
    /**
     * Execute
     * @param tween {Tween} The Tween object to be operated. Default: this
     * @returns {Tween} Tween object itself
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * 执行
     * @param tween {Tween} 需要操作的 Tween 对象，默认this
     * @returns {Tween} Tween对象本身
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    play(tween?: Tween): Tween;
    /**
     * Pause
     * @param tween {Tween} The Tween object to be operated. Default: this
     * @returns {Tween} Tween object itself
     * @version
     * @platform Web,Native
     * @language en_US
     */
    /**
     * 暂停
     * @param tween {Tween} 需要操作的 Tween 对象，默认this
     * @returns {Tween} Tween对象本身
     * @version
     * @platform Web,Native
     * @language zh_CN
     */
    pause(tween?: Tween): Tween;
    /**
     * @method Tween#tick
     * @param delta {number}
     * @private
     * @version
     * @platform Web,Native
     */
    $tick(delta: number): void;
}}