import { Camera } from "./Camera";

/**
 * 
 */
export class PerspectiveCamera extends Camera {
	zoom: number;
	focus: number;
	/**
	 * 
	 * @param fov 张角
	 * @param aspect 长宽比例width/height
	 * @param near 最近近距离
	 * @param far 最远远距离
	 */
	constructor(
		public fov: number = 50,
		public aspect: number = 1,
		public near: number = 0.1,
		public far: number = 2000
	) {
		super();
		this._instanceType = 'PerspectiveCamera';
		this.zoom = 1;
		this.focus = 10;

		this.updateProjectionMatrix();
	}
	set(
		fov: number = 50,
		aspect: number = 1,
		near: number = 0.1,
		far: number = 2000
	) {
		this.fov = fov;
		this.aspect = aspect;
		this.near = near;
		this.far = far;

		this.zoom = 1;
		this.focus = 10;

		this.updateProjectionMatrix();
	}

	copy(source: PerspectiveCamera, recursive: boolean = true) {
		super.copy(source, recursive)

		this.fov = source.fov;
		this.zoom = source.zoom;

		this.near = source.near;
		this.far = source.far;
		this.focus = source.focus;

		this.aspect = source.aspect;

		return this;
	}

	/**
	 * 更新
	 */
	updateProjectionMatrix() {
		this.projectionMatrix.setPerspective(this.fov, this.aspect, this.near, this.far);
		this.projectionMatrixInverse.setInverseOf(this.projectionMatrix);
	}
}