import { Shader } from "../../2d/renderers/webgl/Shader";

//到时还要加上顶点变形的和骨骼变形的
const vertex =
    `attribute vec3 aPosition;
uniform mat4 uLightSpaceMatrix;
uniform mat4 uModelMatrix;
void main() {
    gl_Position = uLightSpaceMatrix * uModelMatrix * vec4( aPosition, 1.0 );
}`;
const fragment =
    `precision mediump float;
    // uniform float uMatAlpha;
    const vec3 PackFactors = vec3( 256. * 256. * 256., 256. * 256.,  256. );
    vec4 packDepthToRGBA( const in float v ) {
        vec4 r = vec4( fract( v * PackFactors ), v );
        r.yzw -= r.xyz * (1. / 256.);
        return r * (256. / 255.);
    }
    void main() {
        // gl_FragColor = vec4( vec3( 1.0 - gl_FragCoord.z ), uMatAlpha );
        gl_FragColor = packDepthToRGBA( gl_FragCoord.z );
}`
const shaderCache = {};
export function getShadowShader() {
    if (!shaderCache[1]) shaderCache[1] = new ShadowShader();
    return shaderCache[1]
}
//到时需要缓存，根据顶点动画等缓存
class ShadowShader extends Shader {
    constructor() {
        super(vertex, fragment)
    }
}