import { Dict } from "../../2d/utils";
import { Geometry } from "../../2d/renderers/webgl/Geometry";
import { Box3 } from "../math/Box3";
import { Sphere } from "../math/Sphere";
import { DataAttribute } from "../../2d/renderers/webgl/DataAttribute";
import { Vector3 } from "../math/Vector3";
import { InterleavedData, InterleavedDataAttribute } from "../../2d/renderers/webgl/InterleavedDataAttribute";

export class Geometry3D extends Geometry {

    //这两个是为了皮肤顶点动画，都是vec4，都进入attribute,且是aSkinWeight,aSkinIndex
    // _skinWeight: Float32Array | number[];
    // _skinIndex: Float32Array | number[];

    boundingBox: Box3 = null;

    boundingSphere: Sphere = null;
    /**
     * 是否按面检测
     */
    doHitFace: boolean = false;

    // /**
    //  * 顶点变形数据数组
    //  */
    // _morphPositions: Float32Array[] | number[][];
    // /**
    //  * 法线变形数据数组
    //  */
    // _morphNormals: Float32Array[] | number[][];
    /**
     * 基本就两个，postion和normal，分别记录了数组
     */
    _morphAttributes: Dict<DataAttribute[] | InterleavedDataAttribute[]>;
    /**
     * gltf为true
     */
    morphTargetsRelative = false;
    constructor() {
        super();
        this._instanceType = "Geometry3D";
    }
    computeBoundingBox() {

        if (!this.boundingBox) this.boundingBox = new Box3();

        var position = this._attributes.position;
        const morphAttributesPosition = this._morphAttributes.position;
        if (position) {
            this.boundingBox.setFromDataAttribute(position);
            if (morphAttributesPosition) {
                let _box = new Box3(), _vector = new Vector3();
                for (let i = 0, il = morphAttributesPosition.length; i < il; i++) {
                    const morphAttribute = morphAttributesPosition[i];
                    _box.setFromDataAttribute(morphAttribute);

                    if (this.morphTargetsRelative) {
                        _vector.addVectors(this.boundingBox.min, _box.min);
                        this.boundingBox.expandByPoint(_vector);

                        _vector.addVectors(this.boundingBox.max, _box.max);
                        this.boundingBox.expandByPoint(_vector);

                    } else {

                        this.boundingBox.expandByPoint(_box.min);
                        this.boundingBox.expandByPoint(_box.max);

                    }

                }

            }
        } else {
            this.boundingBox.makeEmpty();
        }

        if (isNaN(this.boundingBox.min.x) || isNaN(this.boundingBox.min.y) || isNaN(this.boundingBox.min.z)) console.error("error vertices data")
    };

    computeBoundingSphere() {

        var box = new Box3();
        var vector = new Vector3();

        if (!this.boundingSphere) this.boundingSphere = new Sphere();

        var position = this._attributes.position;
        const morphAttributesPosition = this._morphAttributes.position;

        if (position) {
            var center = this.boundingSphere.center;
            box.setFromDataAttribute(position);


            if (morphAttributesPosition) {
                let _boxMorphTargets = new Box3();
                for (let i = 0, il = morphAttributesPosition.length; i < il; i++) {

                    const morphAttribute = morphAttributesPosition[i];
                    _boxMorphTargets.setFromDataAttribute(morphAttribute);

                    if (this.morphTargetsRelative) {

                        vector.addVectors(box.min, _boxMorphTargets.min);
                        box.expandByPoint(vector);

                        vector.addVectors(box.max, _boxMorphTargets.max);
                        box.expandByPoint(vector);
                    } else {
                        box.expandByPoint(_boxMorphTargets.min);
                        box.expandByPoint(_boxMorphTargets.max);
                    }
                }
            }


            box.getCenter(center);
            // hoping to find a boundingSphere with a radius smaller than the
            // boundingSphere of the boundingBox: sqrt(3) smaller in the best case
            var maxRadiusSq = 0;
            for (var i = 0, il = position.count; i < il; i++) {
                vector.x = position.getX(i);
                vector.y = position.getY(i);
                vector.z = position.getZ(i);
                maxRadiusSq = Math.max(maxRadiusSq, center.distanceToSquared(vector));
            }

            if (morphAttributesPosition) {
                let _offset = new Vector3();
                for (let i = 0, il = morphAttributesPosition.length; i < il; i++) {

                    const morphAttribute = morphAttributesPosition[i];
                    const morphTargetsRelative = this.morphTargetsRelative;

                    for (let j = 0, jl = morphAttribute.count; j < jl; j++) {

                        // vector.fromBufferAttribute(morphAttribute, j);
                        vector.set(
                            morphAttribute.getX(j),
                            morphAttribute.getY(j),
                            morphAttribute.getZ(j)
                        )


                        if (morphTargetsRelative) {
                            // _offset.fromBufferAttribute(position, j);
                            _offset.set(
                                position.getX(j),
                                position.getY(j),
                                position.getZ(j)
                            )
                            vector.add(_offset);
                        }

                        maxRadiusSq = Math.max(maxRadiusSq, center.distanceToSquared(vector));

                    }

                }

            }

            this.boundingSphere.radius = Math.sqrt(maxRadiusSq);
            if (isNaN(this.boundingSphere.radius)) console.error("error vertices data")
        }
    };

    copy(source: Geometry3D) {
        //里面处理index和_attributes
        super.copy(source);
        //
        const { _morphAttributes, boundingBox, boundingSphere } = source

        this.boundingBox = boundingBox ? boundingBox.clone() : null;
        this.boundingSphere = boundingSphere ? boundingSphere.clone() : null;

        this._morphAttributes = {};
        let interleavedDatasClone: Dict<InterleavedData> = {};
        for (const name in _morphAttributes) {
            const array = [];
            const morphAttribute = _morphAttributes[name];
            for (let i = 0; i < morphAttribute.length; i++) {
                array.push(morphAttribute[i].clone(interleavedDatasClone))
            }
            //赋值给自己
            this._morphAttributes[name] = array;
        }
        this.morphTargetsRelative = source.morphTargetsRelative;

        return this
    }
    clone() {
        return new Geometry3D().copy(this);
    }
    destroy() {
        //TODO
        super.destroy();
    }
}






