import { Dict, hex2rgb, string2hex } from "../../../utils";
import { IWebglShader } from "../../managers/ShaderManager";
import { WebglRenderer } from "../../WebglRenderer";
import { IShaderUniformData, UniformType } from "./UniformType";

/**
 * 对于自行设置了uniforms的着色器，
 * @param shader 
 * @param uniformsData 
 * @param renderer 
 * @param textureStart 不传表示，不绑定特定纹理通道
 */
export function syncUniforms(shader: IWebglShader, uniformsData: Dict<IShaderUniformData>, renderer: WebglRenderer, textureStart?: number) {
    for (const i in uniformsData) {
        const { type, value } = uniformsData[i];
        //以着色器为准
        if (!shader.uniforms[i]) continue;
        if (type === UniformType.texture) {
            //同一个着色器不能覆盖自身的，只能覆盖别人的，但是有没有可能合图集，最后使用的同一个纹理呢？TODO待测试，尽量别这么玩吧
            //待测试，同一纹理占用多个通道会不会出问题
            shader.uniforms[i] = renderer.textureManager.bind(value.baseTexture, textureStart);
            if (typeof (textureStart) == "number") textureStart++;
        }
        else if (type === UniformType.color) {
            if (typeof value == "number") {
                shader.uniforms[i] = hex2rgb(value);
            }
            else if (typeof value == "string") {
                shader.uniforms[i] = hex2rgb(string2hex(value));
            }
            else {//默认数组
                shader.uniforms[i] = value;
            }
        }
        else if (type === UniformType.matrix3) {
            shader.uniforms[i] = value.toArray ? value.toArray(true) : value;
        }
        else if (type === UniformType.vector2 ||
            type === UniformType.vector3 ||
            type === UniformType.vector4 ||
            type === UniformType.matrix4
        ) {
            shader.uniforms[i] = value.toArray ? value.toArray() : value;
        }
        //其他都直接赋值
        else {
            shader.uniforms[i] = value;
        }
    }
}