import { BLEND_MODES } from "../const";

/**
 * 矫正混色模式，因为有预乘alpha的
 * @private
 * @return {Array<number[]>} Mapped modes.
 */
function mapPremultipliedBlendModes() {
    var pm = [];
    var npm = [];

    for (var i = 0; i < 32; i++) {
        pm[i] = i;
        npm[i] = i;
    }

    pm[BLEND_MODES.NORMAL_NPM] = BLEND_MODES.NORMAL;
    pm[BLEND_MODES.ADD_NPM] = BLEND_MODES.ADD;
    pm[BLEND_MODES.SCREEN_NPM] = BLEND_MODES.SCREEN;

    npm[BLEND_MODES.NORMAL] = BLEND_MODES.NORMAL_NPM;
    npm[BLEND_MODES.ADD] = BLEND_MODES.ADD_NPM;
    npm[BLEND_MODES.SCREEN] = BLEND_MODES.SCREEN_NPM;

    var array = [];
    //0是非预乘alpha的
    array.push(npm);
    //1是预乘alpha的
    array.push(pm);

    return array;
}
//导出矫正后的
export const premultiplyBlendMode = mapPremultipliedBlendModes();