import { CanvasRenderer } from "../renderers/CanvasRenderer";
import RenderTexture from "../texture/RenderTexture";
import { Matrix, Rectangle } from "../math";
import { DisplayObject } from "../display/DisplayObject";
import { createCanvas } from "./tbminiAdapte";


// 作为将显示对象导出成图片的render渲染器
let _dRender: CanvasRenderer = null;
let _dCanvas
let tempMatrix = new Matrix()
/**
 * 将显示对象转成base64的图片数据
 * 小程序上有问题，尽量不用，矢量图的canvas绘制被删了
 * @method toDisplayDataURL
 * @static
 * @param {DisplayObject} obj 显示对象
 * @param {Rectangle} rect 需要裁切的区域，默认不裁切
 * @param {Object} typeInfo {type:"png"}  或者 {type:"jpeg",quality:100}  png格式不需要设置quality，jpeg 格式需要设置quality的值 从1-100
 * @param {number} bgColor 十六进制颜色值如 0xffffff 默认值为空的情况下，jpeg格式的话就是黑色底，png格式的话就是透明底,
 * @return {string} base64格式数据
 * @example
 *      toDisplayDataURL(DisplayObj, {
 *               x: 0,
 *               y: 32,
 *               width: 441,
 *               height: 694
 *       }, {
 *               type: "jpeg"//数据类型jpg/png
 *               quality: 90//图片质量值1-100,png格式不需要设置quality
 *       }, '#CDDBEB');
 *
 * Tip:在一些需要上传图片，编辑图片，需要提交图片数据，分享作品又或者长按保存作品的项目，运用toDisplayDataURL方法把显示对象base64就是最好不过的选择了。
 */
export default function toDisplayDataURL(obj: DisplayObject, rect: Rectangle = null, typeInfo: any = null, bgColor: number = 0x000000): string {
    var bounds = obj.getLocalBounds();
    let w: number = rect ? rect.width : bounds.width;
    let h: number = rect ? rect.height : bounds.height;
    let x: number = rect ? rect.x : bounds.x;
    let y: number = rect ? rect.y : bounds.y;
    if (!_dRender) {
        var canvas: HTMLCanvasElement = createCanvas();
        canvas.width = w;
        canvas.height = h;
        _dCanvas = canvas
        _dRender = new CanvasRenderer(canvas.getContext("2d"), w, h);
    } else {
        _dCanvas.width = w;
        _dCanvas.height = h;
    }

    if (!typeInfo) {
        typeInfo = { type: "png" };
    }

    //以防万一，刷一次
    obj.transform.updateLocalMatrix();
    tempMatrix.copy(obj.transform.localMatrix);
    tempMatrix.invert();
    tempMatrix.tx -= x;
    tempMatrix.ty -= y;
    _dRender.render(obj, null, tempMatrix);
    // document.body.appendChild(_canvasBuffer.baseTexture.source)
    return _dCanvas.toDataURL("image/" + typeInfo.type, typeInfo.quality);
};

//利用离屏纹理，暂时背景色无效，因为canvasRender暂时不对离屏纹理填充背景色，以后有需要再说
// let _canvasBuffer: RenderTexture = null;
/**
 * 将显示对象转成base64的图片数据
 * @method toDisplayDataURL
 * @static
 * @param {DisplayObject} obj 显示对象
 * @param {Rectangle} rect 需要裁切的区域，默认不裁切
 * @param {Object} typeInfo {type:"png"}  或者 {type:"jpeg",quality:100}  png格式不需要设置quality，jpeg 格式需要设置quality的值 从1-100
 * @param {number} bgColor 十六进制颜色值如 0xffffff 默认值为空的情况下，jpeg格式的话就是黑色底，png格式的话就是透明底,
 * @return {string} base64格式数据
 */
/*function toDisplayDataURL(obj: DisplayObject, rect: Rectangle = null, typeInfo: any = null, bgColor: number = 0x000000): string {
    var bounds = obj.getLocalBounds();
    let w: number = rect ? rect.width : bounds.width;
    let h: number = rect ? rect.height : bounds.height;
    let x: number = rect ? rect.x : bounds.x;
    let y: number = rect ? rect.y : bounds.y;
    if (!_canvasBuffer) {
        _canvasBuffer = RenderTexture.create(w, h);
    } else {
        _canvasBuffer.resize(w, h)
    }
    if (!_dRender) {
        _dRender = new CanvasRenderer({});
    }
    if (!typeInfo) {
        typeInfo = { type: "png" };
    }
    if (typeInfo.type == "png") {
        _dRender.transparent = true;
    } else {
        _dRender.transparent = false;
        _dRender.backgroundColor = bgColor
    }
    obj.transform.updateLocalMatrix();
    tempMatrix.copy(obj.transform.localMatrix);
    tempMatrix.invert();
    tempMatrix.tx -= x;
    tempMatrix.ty -= y;
    _dRender.render(obj, _canvasBuffer, tempMatrix);
    return _canvasBuffer.baseTexture.source["toDataURL"]("image/" + typeInfo.type, typeInfo.quality);
};*/