import { Dict } from "../../2d/utils";
import { HashObject } from "../../2d/HashObject";
import { WebglRenderer } from "../../2d/renderers/WebglRenderer";
import { IMaterial } from "./IMaterial";
import { IShaderUniformData } from "../../2d/renderers/webgl/shader/UniformType";
import { Shader } from "../../2d/renderers/webgl/Shader";

// precision mediump float;
// precision mediump int;

//
// uniform mat4 uViewMatrix;
// uniform mat4 uProjectionMatrix;
// uniform mat4 uModelMatrix;

export const defaultVertexShader3d =
    `attribute vec3 aPosition;
uniform mat4 uViewMatrix;
uniform mat4 uProjectionMatrix;
uniform mat4 uModelMatrix;
void main() {
    gl_Position = uProjectionMatrix * uViewMatrix * uModelMatrix * vec4( aPosition, 1.0 );
}`;
export const defaultFragmentShader3d =
    `void main() {
    gl_FragColor = vec4( 1.0, 0.0, 0.0, 1.0 );
}`

/**
 * 不考虑宏定义，否则自行修改getShader及缓存方式
 * 这三个必备，除非自己不需要几何的矩阵信息
 * uniform mat4 uViewMatrix;
 * uniform mat4 uProjectionMatrix;
 * uniform mat4 uModelMatrix;
 */
export class ShaderMaterial extends IMaterial {
    /**
     * 标记下。是自定义着色器
     */
    get isShaderMaterial(): boolean {
        return true;
    };
    protected _shader: Shader;
    public get shader() {
        return this._shader
    }
    public get uniformsData() {
        return this._shader.uniformsData;
    }
    public get uniforms() {
        return this._shader.uniforms;
    }
    constructor(
        vertexShader = defaultVertexShader3d,
        fragmentShader = defaultFragmentShader3d,
        uniformsData: Dict<IShaderUniformData>
    ) {
        super();
        this._instanceType = "ShaderMaterial";
        this._shader = new Shader(vertexShader, fragmentShader, uniformsData)
    }

    destroy() {
        this._shader.destroy();
        this._shader = null;
        super.destroy();
    }
}

