




import { BLEND_MODES } from "../../2d/const";
import { HashObject } from "../../2d/HashObject";

export enum RenderSideType {
    /**
     * 正面才渲染，逆时针顶点
     */
    FrontSide = 0,
    /**
     * 反面才渲染，顺时针顶点顺序
     */
    BackSide,
    /**
     * 两面都渲染
     */
    DoubleSide,
}
/**
 * 材质基类，一些公用的属性，一般是渲染状态机的属性，不会包括uniform的属性
 * 
 */
export abstract class IMaterial extends HashObject {
    /**
     * 是否用线框形式绘制
     */
    wireframe: boolean = false;
    /**
     * 材质渲染面，这个还影响法线的，也就是对着色器里也有影响，TODO暂时不管吧
     */
    side: RenderSideType = RenderSideType.FrontSide;
    // /**
    //  * BLEND_MODES到时都得重新整理下，现在很多是无效的
    //  * 暂时不加three得自定义混色，也不设置是否预乘透明度，只用引擎给的
    //  */
    // blending: BLEND_MODES = BLEND_MODES.NORMAL
    /**
     * 是否允许透明，默认false，true的会放后面渲染，非透明的先渲染
     * 一般判断alpha<1||transparent
     */
    transparent: boolean = false;
    /**
     * 是否进行深度检测，默认true depthFunc先不加
     */
    depthTest: boolean = true;
    /**
     * 是否进行深度写入,默认true
     */
    depthWrite: boolean = true;
    constructor() {
        super();
        this._instanceType = "IMaterial";
    }
    copy(material: IMaterial) {
        [
            "wireframe",
            "side",
            "transparent",
            "depthTest",
            "depthWrite",
        ].forEach((p) => this[p] = material[p])
        return this;
    }
    destroy() {

    }
}

export interface IMaterialParams {
    wireframe?: boolean,
    side?: RenderSideType,
    transparent?: boolean,
    depthTest?: boolean,
    depthWrite?: boolean,
}