import { Geometry3D } from "../core/Geometry3D";
import { Mesh3D } from "../core/Mesh3D";
import { BaseMaterial } from "../materials";
import { hex2rgb } from "../../2d/utils";
import { DataAttribute } from "../../2d/renderers/webgl/DataAttribute";


export class GridHelper extends Mesh3D {

	constructor(
		size: number = 10,
		divisions: number = 10,
		color1: number = 0x444444,
		color2: number = 0x888888
	) {
		var center = divisions / 2;
		var step = size / divisions;
		var halfSize = size / 2;
		var colorArr1 = hex2rgb(color1);
		var colorArr2 = hex2rgb(color2);

		var vertices = [], colors = [];

		for (var i = 0, j = 0, k = - halfSize; i <= divisions; i++, k += step) {

			vertices.push(- halfSize, 0, k, halfSize, 0, k);
			vertices.push(k, 0, - halfSize, k, 0, halfSize);

			var color = i === center ? colorArr1 : colorArr2;

			let count = 4;
			while (count--) {
				colors.push(color[0], color[1], color[2])
			}
		}

		var geometry = new Geometry3D()
			.addAttribute('aPosition', new DataAttribute(new Float32Array(vertices), 3))
			.addAttribute('aColor', new DataAttribute(new Float32Array(colors), 3));

		var material = new BaseMaterial({ wireframe: true, useVertexColor: true });

		super(geometry, material)
	}

}
