import { Mesh3D } from '../core/Mesh3D';
import { Box3 } from '../math/Box3';
import { Geometry3D } from '../core/Geometry3D';
import { BaseMaterial } from '../materials';
import { DataAttribute } from '../../2d/renderers/webgl/DataAttribute';

export class Box3Helper extends Mesh3D {
	public box: Box3
	constructor(box: Box3, color: number = 0xffff00) {
		var indices = [0, 1, 1, 2, 2, 3, 3, 0, 4, 5, 5, 6, 6, 7, 7, 4, 0, 4, 1, 5, 2, 6, 3, 7];
		var positions = [1, 1, 1, - 1, 1, 1, - 1, - 1, 1, 1, - 1, 1, 1, 1, - 1, - 1, 1, - 1, - 1, - 1, - 1, 1, - 1, - 1];
		var geo = new Geometry3D()
			.addAttribute('aPosition', new DataAttribute(new Float32Array(positions), 3));
		geo.index = indices;

		super(geo, new BaseMaterial({ wireframe: true, color }))
		this.box = box;
		this.mouseChildren = this.mouseEnable = false;
	}
	updateWorldMatrix(updateParents: boolean = false, updateChildren: boolean = true) {
		var box = this.box;
		if (box.isEmpty()) return;
		box.getCenter(this.position);
		box.getSize(this.scale);
		this.scale.multiplyScalar(0.5);
		super.updateWorldMatrix(updateParents, updateChildren)
	}
}
