import { Object3D } from "./Object3D";
import { Matrix4 } from "../math/Matrix4";
import { Ray } from "../math/Ray";
import { Sphere } from "../math/Sphere";
import { Vector3 } from "../math/Vector3";
import { Raycaster, IntersectData } from "./Raycaster";
import { Geometry3D } from "./Geometry3D";
import { IMaterial, RenderSideType } from "../materials/IMaterial";

const templeSphere: Sphere = new Sphere();
const tempMatrix: Matrix4 = new Matrix4();
const tempRay: Ray = new Ray();
const tempPoint = new Vector3();
//现在基本所有3d的显示对象(sprite3d以及所有help)都继承自Mesh3D，但是以后尽量分开，包括line和point，以及材质也需要分开，TODO
export class Mesh3D extends Object3D {
    /**
     * 用于变形权重，只能获取，修改只能内部修改
     */
    private _morphTargetInfluences: number[];
    get morphTargetInfluences() {
        return this._morphTargetInfluences;
    }
    //这个暂时不知道有啥用，到时看three的
    // morphTargetDictionary
    constructor(
        public geometry: Geometry3D,
        public material: IMaterial
    ) {
        super();
        this._instanceType = "Mesh3D";
        this.updateMorphTargets();
    }
    _render(renderer) {
        if (!this.visible) return;
        renderer.batchManager.setObjectRenderer(renderer.plugins["d3"]);
        renderer.plugins["d3"].render(this)
    }

    updateMorphTargets() {
        var morphPositions = this.geometry._morphAttributes.position;
        if (morphPositions) {
            this._morphTargetInfluences = [];
            //根据morphPositions的长度来定权重长度
            for (var i = 0; i < morphPositions.length; i++) this._morphTargetInfluences.push(0);
        }
    }

    raycast(raycaster: Raycaster, intersects: IntersectData[]) {
        if (!this.visible || !this.geometry || !this.material || this.material.wireframe) return;
        var geometry = this.geometry;
        var matrixWorld = this._worldMatrix;

        // Checking boundingSphere distance to ray

        if (!geometry.boundingSphere) geometry.computeBoundingSphere();

        templeSphere.copy(geometry.boundingSphere);
        templeSphere.applyMatrix4(matrixWorld);

        if (raycaster.ray.intersectsSphere(templeSphere) === false) return;

        //

        tempMatrix.setInverseOf(matrixWorld);
        tempRay.copy(raycaster.ray).applyMatrix4(tempMatrix);
        // Check boundingBox before continuing
        if (geometry.boundingBox !== null && tempRay.intersectsBox(geometry.boundingBox) === false) return;

        //如果不需要面检测，到此为止了
        if (!geometry.doHitFace) {
            // raycaster.ray.origin.distanceTo(templeSphere.center) - templeSphere.radius,
            intersects.push({//距离简单点
                distance: raycaster.ray.origin.distanceTo(templeSphere.center) - templeSphere.radius,
                object: this
            })
            return;
        }

        var intersection: IntersectData;

        var a = new Vector3(), b = new Vector3(), c = new Vector3();
        var index = geometry.index;
        var position = geometry._attributes.aPosition;

        if (index) {
            for (var i = 0; i < index.count; i += 3) {
                var i1 = index.getX(i), i2 = index.getY(i), i3 = index.getZ(i);
                a.set(position.getX(i1), position.getY(i1), position.getZ(i1));
                b.set(position.getX(i2), position.getY(i2), position.getZ(i2));
                c.set(position.getX(i3), position.getY(i3), position.getZ(i3));
                intersection = checkIntersection(
                    this,
                    raycaster,
                    tempRay,
                    a,
                    b,
                    c,
                    tempPoint
                );
                if (intersection) {//有一个就出
                    intersects.push(intersection);
                    break;
                }
            }
        }
        else if (position) {
            for (var i = 0; i < position.count; i += 3) {
                a.set(position.getX(i), position.getY(i), position.getZ(i));
                b.set(position.getX(i + 1), position.getY(i + 1), position.getZ(i + 1));
                c.set(position.getX(i + 2), position.getY(i + 2), position.getZ(i + 2));
                intersection = checkIntersection(
                    this,
                    raycaster,
                    tempRay,
                    a,
                    b,
                    c,
                    tempPoint
                );
                if (intersection) {//有一个就出
                    intersects.push(intersection);
                    break;
                }
            }
        }
    };
    copy(source: Mesh3D, recursive: boolean = true) {
        super.copy(source, recursive);
        if (source.morphTargetInfluences) {//变形的数据
            this._morphTargetInfluences = source.morphTargetInfluences.slice();
        }
        //暂时不用
        // if ( source.morphTargetDictionary !== undefined ) {
        // 	this.morphTargetDictionary = Object.assign( {}, source.morphTargetDictionary );
        // }
        return this
    }
    /**
     * 克隆方法
     * @param recursive 默认克隆子级
     */
    clone(recursive: boolean = true) {
        return new Mesh3D(this.geometry, this.material).copy(this, recursive);
    }
}



var intersectionPointWorld = new Vector3();
function checkIntersection(
    object: Mesh3D,
    raycaster: Raycaster,
    ray: Ray,
    pA: Vector3,
    pB: Vector3,
    pC: Vector3,
    point: Vector3
): IntersectData {
    var material = object.material
    var intersect: Vector3 | null;
    if (material.side === RenderSideType.BackSide) {
        intersect = ray.intersectTriangle(pC, pB, pA, true, point);
    } else {
        intersect = ray.intersectTriangle(pA, pB, pC, material.side !== RenderSideType.DoubleSide, point);
    }
    if (intersect === null) return null;

    intersectionPointWorld.copy(point);
    intersectionPointWorld.applyMatrix4(object._worldMatrix);
    var distance = raycaster.ray.origin.distanceTo(intersectionPointWorld);
    if (distance < raycaster.near || distance > raycaster.far) return null;
    return {
        distance: distance,
        point: intersectionPointWorld.clone(),
        object: object
    };
}
//交付分
var a = 5
//时间分每天
var b = 1
//极限时间
var j = 15
//项目基础时间
var i = 4

function aaa(t) {
    t -= i
    return a + t * b + (t * t) / j * a / i / i;
}

function bbb(t) {
    //完整项目按4天
    t -= i
    return a + t * b + (t * t) / j * a / i / i;
}