import { Mesh3D } from '../core/Mesh3D';
// import { Vector4 } from '../math/Vector4.js';
import { Skeleton3D } from './Skeleton3D';
import { Bone3D } from './Bone3D';
import { Matrix4 } from '../math/Matrix4';
import { BaseMaterial } from '../materials';
import { Geometry3D } from '../core/Geometry3D';
import { Vector4 } from '../math/Vector4';

export class SkinnedMesh3D extends Mesh3D {
	public bindMode: "attached" | "detached" = "attached";
	public bindMatrix = new Matrix4();
	public bindMatrixInverse = new Matrix4();
	public skeleton: Skeleton3D;
	constructor(geometry: Geometry3D, material: BaseMaterial) {
		super(geometry, material)
		this._instanceType = "SkinnedMesh3D";

		this.normalizeSkinWeights();
	}

	bind(skeleton: Skeleton3D, bindMatrix: Matrix4) {

		this.skeleton = skeleton;

		if (bindMatrix === undefined) {

			this.updateWorldMatrix();

			this.skeleton.calculateInverses();

			bindMatrix = this._worldMatrix;

		}

		this.bindMatrix.copy(bindMatrix);
		this.bindMatrixInverse.setInverseOf(bindMatrix);

	}

	pose() {

		this.skeleton.pose();

	}

	normalizeSkinWeights() {
		var scale, i;
		if (this.geometry) {
			var vec = new Vector4();
			var skinWeight = this.geometry._attributes.skinWeight;
			var len = skinWeight.count || 0;
			for (i = 0; i < len; i++) {

				vec.set(
					skinWeight.getX( i ),
					skinWeight.getY( i ),
					skinWeight.getY( i ),
					skinWeight.getY( i ),
				)

				scale = 1.0 / vec.manhattanLength();

				if (scale !== Infinity) {

					vec.multiplyScalar(scale);

				} else {

					vec.set(1, 0, 0, 0); // do something reasonable

				}

				skinWeight.setXYZW(i, vec.x, vec.y, vec.z, vec.w);
			}

		}

	}

	updateWorldMatrix() {
		super.updateWorldMatrix()
		if (this.bindMode === 'attached') {
			this.bindMatrixInverse.setInverseOf(this._worldMatrix);
		} else if (this.bindMode === 'detached') {
			this.bindMatrixInverse.setInverseOf(this.bindMatrix);
		} else {

		}
	}
	update() {
		if (!this.visible) return;
		this.skeleton.update();
		super.update();
	}

	clone() {

		return new SkinnedMesh3D(this.geometry, this.material).copy(this);

	}
}


