import { HashObject } from "../../HashObject";
import { Dict } from "../../utils";
import { IShaderUniformData } from "./shader/UniformType";


export class Shader extends HashObject {
    /**
     * 着色器标识，可以根据参数，也可以直接是顶点和片元的字符串，默认就用v,f
     */
    _glShaderKey: string;
    protected _vertexSrc: string;
    get vertexSrc() { return this._vertexSrc }
    protected _fragmentSrc: string;
    get fragmentSrc() { return this._fragmentSrc }


    uniformsData: Dict<IShaderUniformData>
    /**
     * 用于uniformsData的get set 方便
     */
    uniforms: any = {}
    /**
     * 
     * @param vertexSrc 
     * @param fragmentSrc 
     * @param uniformsData 自行添加的uniform类型和默认值，用于和glShader同步，其实传的目的应该是，不去包括公用的一些属性，只修改自己传的，其他都默认，这样是不是着色器写的有问题，TODO
     * @param removeBracketUnifroms 解析uniform时是否需要移除中括号，对于数字数组应该移除，然后传数组，需要移除中括号的uniform，比如["morphTargetInfluences","uBoneMatrices","uSamplers"]
     * @param attributeLocations 这个先留着吧,暂时就没有用到过
     */
    constructor(
        vertexSrc: string,
        fragmentSrc: string,
        uniformsData?: Dict<IShaderUniformData>,
        public removeBracketUnifroms?: string[],
        public attributeLocations?: Dict<number>
    ) {
        super();
        this._instanceType = "Shader";
        this._vertexSrc = vertexSrc;
        this._fragmentSrc = fragmentSrc;

        this.uniformsData = uniformsData || null;
        this.generateUniformsDataGetSet();
        //缓存唯一值
        this._glShaderKey = generateShaderKey(vertexSrc, fragmentSrc);
    };
    get project2dUniformName() {
        return "projectionMatrix"
    }
    generateUniformsDataGetSet() {
        let data = this.uniformsData;
        if (!data) return;
        this.uniforms = {};
        for (var key in data) {
            Object.defineProperty(this.uniforms, key, {
                get: function () {
                    return data[key].value;
                },
                set: function (value) {
                    data[key].value = value;
                }
            });
        }
    }
    destroy() {
        this.uniformsData = null;
        this._vertexSrc = null;
        this._fragmentSrc = null;
        this._glShaderKey = null;
    }
}
/**
 * 默认逗号间隔，统一的方法
 * @param str 
 * @returns 
 */
export function generateShaderKey(...str: string[]) {
    //默认逗号间隔，不传就是逗号
    return str.join();
}
