import { BUFFER_USAGE } from "../../const";
import { HashObject } from "../../HashObject";
import { Dict } from "../../utils";
import { DataAttribute, IDataAttribute } from "./DataAttribute";

//用作交错数据
export class InterleavedData extends HashObject implements IDataAttribute {
    usage: BUFFER_USAGE = BUFFER_USAGE.STATIC_DRAW;
    _updateId: number = 0;
    /**
     * 
     * @param array 
     * @param stride 每个顶点需要数据的长度
     */
    constructor(
        array: any,
        public stride: number
    ) {
        super()
        this._instanceType = "InterleavedData";
        this._count = array ? array.length / stride : 0;
        this._array = array;
    }
    private _count: number
    /**
     * 实际数据数量，比如顶点个数，array.length/itemSize
     */
    get count() {
        return this._count;
    }
    private _array: any;
    /**
     * 数据可以整体替换，但是对应的glbuffer还是只有一个，且vao也不需要重新处理通道，index是否需要每次bind，index也替换里面的数据（buffer还是不变）
     */
    get array() {
        return this._array;
    }
    set array(array: any) {
        if (Array.isArray(array)) {
            throw new TypeError('Array should be a Typed Array');
        }
        this._count = array ? array.length / this.stride : 0;
        this._array = array;
        this._updateId++;
    }
    copy(source: InterleavedData) {
        this.stride = source.stride;
        this.array = new source.array.constructor(source.array);
        this.usage = source.usage;
        return this;
    }

    set(value: ArrayLike<number>, offset = 0) {
        this.array.set(value, offset);
        return this;
    }
    //这个得考虑下，怎么搞TODO，尽量先不用
    clone() {
        return new InterleavedData(null, 0).copy(this);
    }
    destroy() {
        this._array = null;
    }
}
export class InterleavedDataAttribute extends HashObject {
    constructor(
        public data: InterleavedData,
        public itemSize: number,
        public offset: number,
        public normalized = false
    ) {
        super();
        this._instanceType = "InterleavedDataAttribute"
    }

    get count() {
        return this.data.count;
    }

    get array() {
        return this.data.array;
    }

    setX(index, x) {
        this.data.array[index * this.data.stride + this.offset] = x;
        return this;
    }

    setY(index, y) {
        this.data.array[index * this.data.stride + this.offset + 1] = y;
        return this;
    }

    setZ(index, z) {
        this.data.array[index * this.data.stride + this.offset + 2] = z;
        return this;
    }

    setW(index, w) {
        this.data.array[index * this.data.stride + this.offset + 3] = w;
        return this;
    }

    getX(index) {
        return this.data.array[index * this.data.stride + this.offset];
    }
    getY(index) {
        return this.data.array[index * this.data.stride + this.offset + 1];
    }

    getZ(index) {
        return this.data.array[index * this.data.stride + this.offset + 2];
    }

    getW(index) {
        return this.data.array[index * this.data.stride + this.offset + 3];
    }

    setXY(index, x, y) {
        index = index * this.data.stride + this.offset;
        this.data.array[index + 0] = x;
        this.data.array[index + 1] = y;
        return this;
    }
    setXYZ(index, x, y, z) {

        index = index * this.data.stride + this.offset;

        this.data.array[index + 0] = x;
        this.data.array[index + 1] = y;
        this.data.array[index + 2] = z;

        return this;

    }

    setXYZW(index, x, y, z, w) {

        index = index * this.data.stride + this.offset;

        this.data.array[index + 0] = x;
        this.data.array[index + 1] = y;
        this.data.array[index + 2] = z;
        this.data.array[index + 3] = w;

        return this;

    }
    //TODO，暂时废弃
    clone(data?: Dict<InterleavedData>) {
        //没有的话就当作分散了
        if (!data) {
            const array = [];
            for (let i = 0; i < this.count; i++) {
                const index = i * this.data.stride + this.offset;
                for (let j = 0; j < this.itemSize; j++) {
                    array.push(this.data.array[index + j]);
                }
            }
            return new DataAttribute(new this.array.constructor(array), this.itemSize, this.normalized);
        } else {
            let id = this.data;
            //取存的InterleavedData
            let idClone = data[id.instanceId];
            if (!idClone) {
                idClone = data[id.instanceId] = id.clone();
            }
            return new InterleavedDataAttribute(
                idClone,
                this.itemSize,
                this.offset,
                this.normalized
            )
        }
    }
    destroy() {
        this.data = null;
    }
}