import { HashObject } from "../../HashObject";
import { Dict } from "../../utils";
import { DataAttribute } from "./DataAttribute";
import { InterleavedData, InterleavedDataAttribute } from "./InterleavedDataAttribute";

export class Geometry extends HashObject {
    /**
     * 所有顶点数据
     */
    _attributes: Dict<DataAttribute | InterleavedDataAttribute> = {};
    constructor() {
        super();
        this._instanceType = "Geometry";
    }
    private _index: DataAttribute = null;
    /**
     * 赋值建议直接用普通数组
     */
    get index(): DataAttribute {
        return this._index;
    }
    set index(index: ArrayLike<number> | DataAttribute) {
        //纯数组的转换下
        if (Array.isArray(index)) {
            //如果索引最大值超过了65535，记得需要开扩展和glType
            this._index = new DataAttribute(new (Math.max(...index) > 65535 ? Uint32Array : Uint16Array)(index), 1);
        }
        else if (index instanceof DataAttribute) {
            this._index = index;
        }
        //不存在
        else if (!index) {
            this._index = null;
        }
        //类型化数组
        else {
            this._index = new DataAttribute(index, 1);
        }
    }

    getAttribute(name: string) {
        return this._attributes[name];
    }
    /**
     * 会覆盖同名attribute
     * @param name 
     * @param attribute 
     * @returns 
     */
    addAttribute(name: string, attribute: DataAttribute | InterleavedDataAttribute): this {
        this._attributes[name] = attribute;
        return this;
    }
    /**
     * 移除
     * @param name 
     * @returns 
     */
    removeAttribute(name: string): this {
        delete this._attributes[name];
        return this;
    }
    clone() {
        return new Geometry().copy(this);
    }
    //
    copy(source: Geometry) {
        const { index, _attributes } = source

        this._index = null;
        if (index) {
            this.index = index.clone();
        }

        this._attributes = {};
        let interleavedDatasClone: Dict<InterleavedData> = {};
        for (const name in _attributes) {
            const attribute = _attributes[name];
            this.addAttribute(name, attribute.clone(interleavedDatasClone));
        }

        return this;
    }
    destroy() {
        //TODO
        // this._index = null;
        // this._attributes = null;
    }
}