import { defaultValue } from "../renderers/webgl/shader/defaultValue";
import { IShaderUniformData } from "../renderers/webgl/shader/UniformType";
import { Dict } from "../utils";

export function extractUniformsFromSrc(vertexSrc, fragmentSrc): Dict<IShaderUniformData> {
    const vertUniforms = extractUniformsFromString(vertexSrc);
    const fragUniforms = extractUniformsFromString(fragmentSrc);
    // return Object["assign"](vertUniforms, fragUniforms);
    return { ...vertUniforms, ...fragUniforms };
}

function extractUniformsFromString(string) {
    const maskRegex = new RegExp('^(projectionMatrix|uSampler|filterArea|filterClamp)$');

    const uniforms = {};
    let nameSplit;

    // clean the lines a little - remove extra spaces / tabs etc
    // then split along ';'
    const lines = string.replace(/\s+/g, ' ')
        .split(/\s*;\s*/);

    // loop through..
    for (let i = 0; i < lines.length; i++) {
        const line = lines[i].trim();

        if (line.indexOf('uniform') > -1) {
            const splitLine = line.split(' ');
            const type = splitLine[1];

            let name = splitLine[2];
            let size = 1;

            if (name.indexOf('[') > -1) {
                // array!
                nameSplit = name.split(/\[|]/);
                name = nameSplit[0];
                size *= Number(nameSplit[1]);
            }

            // if (!name.match(maskRegex)) {//先所有的都解出来
            uniforms[name] = {
                value: defaultValue(type, size),
                type,
                name,//name和size其实用不到
                size,
            };
            // }
        }
    }

    return uniforms;
}
