
//默认下顶点着色器都用highp float精度，片元着色器用mediump float
/**
 * 最简滤镜顶点着色器，很常用，因为多数是处理片元的
 */
export const defaultFilterVert =
    "precision highp float;" +
    "attribute vec2 aVertexPosition;" +
    "attribute vec2 aTextureCoord;" +

    "uniform mat3 projectionMatrix;" +

    "varying vec2 vTextureCoord;" +

    "void main(void){" +
    "gl_Position = vec4((projectionMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);" +
    "vTextureCoord = aTextureCoord;" +
    "}"
/**
 * 啥也没干的最简单的片元着色器
 */
export const defaultFilterFrag =
    `varying vec2 vTextureCoord;
    uniform sampler2D uSampler;
    void main() {
        gl_FragColor = texture2D( uSampler, vTextureCoord );
    }`;
/**
 * 带滤镜矩阵的的顶点着色器，用于比如displaceFilter
 */
export const defaultFilterMatrixVert =
    "precision highp float;" +
    "attribute vec2 aVertexPosition;" +
    "attribute vec2 aTextureCoord;" +

    "uniform mat3 projectionMatrix;" +
    "uniform mat3 filterMatrix;" +

    "varying vec2 vTextureCoord;" +
    "varying vec2 vFilterCoord;" +

    "void main(void){" +
    "gl_Position = vec4((projectionMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);" +
    "vFilterCoord = ( filterMatrix * vec3( aTextureCoord, 1.0)  ).xy;" +
    "vTextureCoord = aTextureCoord;" +
    "}"

/**
 * 带滤镜矩阵的的片元着色器，很少用到，基本都是自定义的，做个参考吧
 */
export const defaultFilterSamplerFrag = [
    'varying vec2 vTextureCoord;',
    'varying vec2 vFilterCoord;',

    'uniform sampler2D uSampler;',
    'uniform sampler2D filterSampler;',

    'void main(void){',
    '   vec4 masky = texture2D(filterSampler, vFilterCoord);',
    '   vec4 sample = texture2D(uSampler, vTextureCoord);',
    '   vec4 color;',
    '   if(mod(vFilterCoord.x, 1.0) > 0.5)',
    '   {',
    '     color = vec4(1.0, 0.0, 0.0, 1.0);',
    '   }',
    '   else',
    '   {',
    '     color = vec4(0.0, 1.0, 0.0, 1.0);',
    '   }',
    // '   gl_FragColor = vec4(mod(vFilterCoord.x, 1.5), vFilterCoord.y,0.0,1.0);',
    '   gl_FragColor = mix(sample, masky, 0.5);',
    '   gl_FragColor *= sample.a;',
    '}',
].join('\n');