import { extractUniformsFromSrc } from './extractUniformsFromSrc';
import { BLEND_MODES } from '../const';
import { Shader } from '../renderers/webgl/Shader';
import { FilterManager, FilterState } from '../renderers/managers/FilterManager';
import { RenderTexture } from '../texture';
import { Dict } from '../utils';
import { IShaderUniformData } from '../renderers/webgl/shader/UniformType';
import { defaultFilterMatrixVert, defaultFilterSamplerFrag } from './defaultShaderSrc';

////有部分固定的attr和uniform需要确定
/**
 * 基本就是一个着色器，暂时不考虑集成GLShader，还不晓得咋搞
 */
export default class Filter extends Shader {

    private _blendMode: BLEND_MODES = BLEND_MODES.NORMAL;
    /**
     * 混色
     */
    get blendMode(): BLEND_MODES {
        return this._blendMode;
    }
    set blendMode(value: BLEND_MODES) {
        this._blendMode = value;
    }

    padding: number = 0;

    protected _resolution: number = 1
    get resolution(): number {
        return this._resolution
    };
    set resolution(v: number) {
        this._resolution = v;
    }

    enabled: boolean = true;

    autoFit: boolean = true;
    /**
     * @param {string} [vertexSrc] 
     * @param {string} [fragmentSrc] 
     * @param {object} [uniformsData] 可以自己传，但是主要以字符串解析为主，尽量不传吧
     */
    constructor(
        vertexSrc: string = defaultFilterMatrixVert,
        fragmentSrc: string = defaultFilterSamplerFrag,
        uniformsData?: Dict<IShaderUniformData>
    ) {
        super(
            vertexSrc,
            fragmentSrc,
            uniformsData || extractUniformsFromSrc(vertexSrc, fragmentSrc)
        )
    }


    apply(filterManager: FilterManager, input: RenderTexture, output: RenderTexture, clear: boolean, currentState?: FilterState) {
        //子类重写
        //自己处理自定义的uniform属性等等
        filterManager.applyFilter(this, input, output, clear);
    }

}
