
//这里都是一些常量
/**
 * 版本号
 * @static
 * @constant
 * @name VERSION
 * @type {string}
 */
export const VERSION = "2.0.67";


let PI: number = Math.PI;
let HalfPI: number = PI >> 1;
let PacPI: number = PI + HalfPI;
/**
 * @method cos
 * @private
 * @param {number} angle,弧度制
 * @return {number}
 */
export function cos(angle: number): number {
    switch (angle) {
        case HalfPI:
        case -PacPI:
            return 0;
        case PI:
        case -PI:
            return -1;
        case PacPI:
        case -HalfPI:
            return 0;
        default:
            return Math.cos(angle);
    }
}

/**
 * @method sin
 * @param {number} angle,弧度制
 * @return {number}
 */
export function sin(angle: number): number {
    switch (angle) {
        case HalfPI:
        case -PacPI:
            return 1;
        case PI:
        case -PI:
            return 0;
        case PacPI:
        case -HalfPI:
            return -1;
        default:
            return Math.sin(angle);
    }
}
/**
 * Two Pi.
 *
 * @static
 * @constant
 * @type {number}
 */
export const PI_2: number = PI * 2;

/**
 * Conversion factor for converting radians to degrees.
 * 弧度转角度
 * @static
 * @constant
 * @type {number}
 */
export const RAD_TO_DEG: number = 180 / PI;

/**
 * Conversion factor for converting degrees to radians.
 * 角度转弧度
 * @static
 * @constant
 * @type {number}
 */
export const DEG_TO_RAD: number = PI / 180;

/**
 * 渲染方式记录
 * @static
 * @constant
 * @name RENDERER_TYPE
 * @type {object}
 * @property {number} UNKNOWN - Unknown render type.
 * @property {number} WEBGL - WebGL render type.
 * @property {number} CANVAS - Canvas render type.
 */
export enum RENDERER_TYPE {
    UNKNOWN = 0,
    WEBGL,
    CANVAS,
};

/**
 * 各种形状
 * @static
 * @constant
 * @name SHAPES
 * @type {object}
 * @property {number} POLY Polygon  多边形
 * @property {number} RECT Rectangle 矩形
 * @property {number} CIRC Circle 圆形
 * @property {number} ELIP Ellipse 椭圆
 * @property {number} RREC Rounded Rectangle 圆角矩形
 */
export enum SHAPES {
    POLY = 0,
    RECT,
    CIRC,
    ELIP,
    RREC,
};

/**
 * 着色器浮点精度
 * @static
 * @constant
 * @name PRECISION
 * @type {object}
 * @property {string} LOW='lowp'
 * @property {string} MEDIUM='mediump'
 * @property {string} HIGH='highp'
 */
export enum PRECISION {
    LOW = 'lowp',
    MEDIUM = 'mediump',
    HIGH = 'highp',
};

/**
 * 文本渐变方式，以后用
 * @static
 * @constant
 * @name TEXT_GRADIENT
 * @type {object}
 * @property {number} LINEAR_VERTICAL 水平渐变
 * @property {number} LINEAR_HORIZONTAL 垂直渐变
 */
export enum TEXT_GRADIENT {
    LINEAR_VERTICAL = 0,
    LINEAR_HORIZONTAL,
};

/**
 * 文本对齐方式  水平
 */
export enum TEXT_ALIGN {
    CENTER = "center",
    LEFT = "left",
    RIGHT = "right",
}

export enum VERTICAL_ALIGN {
    MIDDLE = "middle",
    UP = "up",
    DOWN = "down",
    TOP = "top",
    BOTTOM = "bottom",
}

/**
 * 文本类型，单行或多行
 */
export enum TEXT_lINETYPE {
    SINGLE = "single",
    MULTI = "multi"
}

/**
 * 画线时的对齐方式
 */
export enum LINE_ALIGNMENT {
    middle = 0.5,
    outter = 1,
    inner = 0
}

/**
 * canvas线头
 */
export enum LINE_CAP {
    BUTT = "butt",
    ROUND = "round",
    SQUARE = "square",
}

/**
 * canvas线连接处
 */
export enum LINE_JOIN {
    MITER = "miter",
    ROUND = "round",
    BEVEL = "bevel"
}


/**
 * 混色模式，暂不支持使用
 * @static
 * @constant
 * @name BLEND_MODES
 * @type {object}
 * @property {number} NORMAL
 * @property {number} ADD
 * @property {number} MULTIPLY
 * @property {number} SCREEN
 * @property {number} OVERLAY
 * @property {number} DARKEN
 * @property {number} LIGHTEN
 * @property {number} COLOR_DODGE
 * @property {number} COLOR_BURN
 * @property {number} HARD_LIGHT
 * @property {number} SOFT_LIGHT
 * @property {number} DIFFERENCE
 * @property {number} EXCLUSION
 * @property {number} HUE
 * @property {number} SATURATION
 * @property {number} COLOR
 * @property {number} LUMINOSITY
 */
export enum BLEND_MODES {
    NORMAL = 0,
    ADD,
    MULTIPLY,
    SCREEN,
    OVERLAY,
    DARKEN,
    LIGHTEN,
    COLOR_DODGE,
    COLOR_BURN,
    HARD_LIGHT,
    SOFT_LIGHT,
    DIFFERENCE,
    EXCLUSION,
    HUE,
    SATURATION,
    COLOR,
    LUMINOSITY,
    NORMAL_NPM,
    ADD_NPM,
    SCREEN_NPM,

    NONE,

    SRC_OVER,

    SRC_IN,
    SRC_OUT,
    SRC_ATOP,
    DST_OVER,
    DST_IN,
    DST_OUT,
    DST_ATOP,
    ERASE,
    SUBTRACT,
};

/**
 * webgl的绘制模式枚举
 * @static
 * @constant
 * @name DRAW_MODES
 * @type {object}
 * @property {number} POINTS
 * @property {number} LINES
 * @property {number} LINE_LOOP
 * @property {number} LINE_STRIP
 * @property {number} TRIANGLES
 * @property {number} TRIANGLE_STRIP
 * @property {number} TRIANGLE_FAN
 */
export enum DRAW_MODES {
    POINTS = 0,
    LINES,
    LINE_LOOP,
    LINE_STRIP,
    TRIANGLES,
    TRIANGLE_STRIP,
    TRIANGLE_FAN,
};

/**
 * 纹理的缩放模式
 * @static
 * @constant
 * @name SCALE_MODES
 * @type {object}
 * @property {number} LINEAR 线性插值光滑缩放
 * @property {number} NEAREST 使用临近像素缩放
 */
export enum SCALE_MODES {
    LINEAR = 0,
    NEAREST,
};

/**
 * 纹理的wrap mode
 * 非2的幂次纹理只能用CLAMP
 * 仅用于webgl模式
 * @static
 * @constant
 * @name WRAP_MODES
 * @type {object}
 * @property {number} CLAMP - The textures uvs are clamped
 * @property {number} REPEAT - The texture uvs tile and repeat
 * @property {number} MIRRORED_REPEAT - The texture uvs tile and repeat with mirroring
 */
export enum WRAP_MODES {
    CLAMP = 33071,
    REPEAT = 10497,
    MIRRORED_REPEAT = 33648,
};

/**
 * 查看类TextureGarbageCollector
 * @static
 * @constant
 * @name GC_MODES
 * @type {object}
 * @property {number} AUTO - 周期性自动回收
 * @property {number} MANUAL - 手动调用
 */
export enum GC_MODES {
    AUTO = 0,
    MANUAL,
};

/**
 * 其实具体常量在gl上是固定的，但是还是做映射吧，BUFFER_TYPE也是
 */
export enum BUFFER_USAGE {
    /**
     * 缓冲区的内容可能经常使用，而不会经常更改。内容被写入缓冲区，但不被读取。
     */
    STATIC_DRAW = "STATIC_DRAW",
    /**
     * 缓冲区的内容可能经常被使用，并且经常更改。内容被写入缓冲区，但不被读取。
     */
    DYNAMIC_DRAW = "DYNAMIC_DRAW",
    /**
     * 缓冲区的内容可能不会经常使用。内容被写入缓冲区，但不被读取。
     */
    STREAM_DRAW = "STREAM_DRAW"
}

export enum BUFFER_TYPE {
    /**
     * 索引数据
     */
    ELEMENT_ARRAY_BUFFER = "ELEMENT_ARRAY_BUFFER",
    /**
     * 顶点数据
     */
    ARRAY_BUFFER = "ARRAY_BUFFER",
}
//还是存映射，不用gl固定的数值
export enum FORMAT_TYPE {
    RGBA = "RGBA",
    RGB = "RGB",
}
export enum DATA_TYPE {
    UNSIGNED_BYTE = "UNSIGNED_BYTE",
    FLOAT = "FLOAT",
    UNSIGNED_SHORT = "UNSIGNED_SHORT",
}
export enum TEXTURE_TARGET_TYPE {
    TEXTURE_2D = "TEXTURE_2D",
    TEXTURE_CUBE_MAP = "TEXTURE_CUBE_MAP",
}