import { Container, Sprite } from "../2d/display";
import { Bone } from "./Bone";
import { Mesh } from "../2d/mesh";
import { Attachment } from "./attachment/Attachment";
import { SpineColor } from "./SpineColor";
import { Spine } from "./Spine";
import { Graphics } from "../2d/graphics";
import { Dict } from "../2d/utils";

//作为插槽容器
//外部控制子级的加入及显示隐藏
export class Slot extends Container {
    currentMesh: Mesh;
    currentSprite: Sprite;
    currentGraphics: Graphics;
    clippingContainer: any;

    meshes: Dict<Mesh>;
    currentMeshName: string;
    sprites: Dict<Sprite>;
    currentSpriteName: string;

    //需要显示的附着图片名字。循环时根据
    attachment: Attachment;
    deform = new Array<number>();//attachmentVertices

    color: SpineColor
    //讲道理原始数据都应该放进data
    // public originAttachment: Attachment;
    constructor(
        /**
         * 绑定的骨骼
         */
        public bone: Bone,
        /**
         * 数据，用于恢复初始状态
         */
        public data: ISlotData,

        private spine: Spine
    ) {
        super();
        this.name = this.data.name;
        this.color = new SpineColor(1, 1, 1, 1);
        if (this.data.color) this.color.setFromString(this.data.color);
        // 数据里的也加一个，不然实时转换性能差
        this.data.sColor = new SpineColor().setFromColor(this.color)
    }
    //重写，根据自己的bone的世界矩阵
    // updateTransform() {
    //     if (!this.visible) return;
    //     this.worldMatrix.setFrom(this.bone.worldMatrix);
    //     this.transform._worldID++;
    //     // 子级attachment
    //     for (var i = 0; i < this.children.length; i++) {
    //         this.children[i].updateTransform();
    //     }
    // }
    getAttachment(): Attachment {
        return this.attachment;
    }
    setAttachment(attachment: Attachment) {
        if (this.attachment == attachment) return;
        this.attachment = attachment;
        this.deform.length = 0;
    }
    //不再动画轨上执行，有需要自行执行
    setToSetupPose() {
        this.color.setFromColor(this.data.sColor);
        if (this.data.attachment == null)
            this.attachment = null;
        else {
            this.attachment = null;
            this.setAttachment(this.spine.getAttachment(this.spine["findSlotIndex"](this.name), this.data.attachment));
        }
    };
}

export interface ISlotData {
    attachment: string//附着显示的皮肤名字
    bone: string//骨骼名字
    name: string//自己名字
    blend: "normal" | "additive" | "multiply" | "screen"//混色
    color: string,
    dark: string,//暂时不用

    sColor?: SpineColor,

}