



import { BLEND_MODES } from "../../2d/const";
import { HashObject } from "../../2d/HashObject";
/**
 * 材质基类，一些公用的属性,，一般是渲染状态机的属性，不会包括uniform的属性
 * 到时着色器还需要分块，否则自定义着色器不好拼
 * 感觉改得越来越像three了
 * 暂时还没启用
 */
export class IMaterial extends HashObject {
    /**
     * 是否用线框形式绘制
     */
    wireframe: boolean = false;
    /**
     * 材质渲染面
     */
    // side: RenderSideType = RenderSideType.FrontSide;
    /**
     * BLEND_MODES到时都得重新整理下，现在很多是无效的
     * 暂时不加three得自定义混色，也不设置是否预乘透明度，只用引擎给的
     */
    blending: BLEND_MODES = BLEND_MODES.NORMAL
    /**
     * 是否允许透明，
     */
    transparent: boolean;
    /**
     * 是否进行深度检测，默认true depthFunc先不加
     */
    depthTest: boolean = true;
    /**
     * 是否进行深度写入,默认true
     */
    depthWrite: boolean = true;
    /**
     * 是否需要更新材质
     */
    needsUpdate: boolean = true;
    constructor() {
        super();
        this._instanceType = "IMaterial"
    }
    destroy() {

    }
}