/**
 * 基础对象，用于标记类名及唯一实例id
 * 只在引擎内部使用
 */
export abstract class HashObject {
    protected _instanceId: number = 0;
    protected _instanceType: string = "HashObject";
    protected static _object_id = 0;

    constructor() {
        this._instanceId = HashObject._object_id++;
    }

    /**
     * 实例唯一id
     * @property instanceId
     * @public
     * @since 1.0.0
     * @return {number}
     * @readonly
     */
    public get instanceId(): number {
        return this._instanceId;
    }

    /**
     * 实例类型
     * @property instanceType
     * @since 1.0.0
     * @public
     * @return {string}
     * @readonly
     */
    public get instanceType(): string {
        return this._instanceType;
    }

    /**
     * 抽象方法，销毁一个对象，子类写
     * @method destroy
     * @since 1.0.0
     * @public
     * @return {void}
     */
    abstract destroy(): void;
}
