
const UglifyJSPlugin = require('uglifyjs-webpack-plugin');
var path = require('path');
var webpack = require('webpack')

module.exports = {
    mode: "development",//'development',production
    entry: {
        "fyge.min": "./src/index.ts",
    },
    output: {
        path: __dirname,
        filename: "build/[name].js",
        libraryTarget: 'umd',
        library: 'FYGE',
    },
    module: {
        rules: [
            {
                test: /\.tsx?$/,
                use: 'ts-loader',
                exclude: /node_modules/
            }
        ]
    },
    devtool: 'source-map',
    plugins: [
        // new UglifyJSPlugin(
        //     { sourceMap: true }
        // ), 
        new webpack.DefinePlugin({
            'process.env.NODE_ENV': JSON.stringify('production')
        })
    ],
    resolve: {
        extensions: ['.webpack.js', '.web.js', '.ts', '.js']
    }
}