
const resolve = require('rollup-plugin-node-resolve');
const commonjs = require('rollup-plugin-commonjs');
const progress = require('rollup-plugin-progress');
const typescript = require('rollup-plugin-typescript');
const { terser } = require('rollup-plugin-terser');

// const fs = require('fs');

//rollup-plugin-typescript里有tslib
//const tslibWrapper = 'var tslib = {__extends: __extends,__assign: __assign,__rest: __rest,__decorate: __decorate,__param: __param,__metadata: __metadata,__awaiter: __awaiter,__generator: __generator,__exportStar: __exportStar,__values: __values,__read: __read,__spread: __spread,__spreadArrays: __spreadArrays,__await: __await,__asyncGenerator: __asyncGenerator,__asyncDelegator: __asyncDelegator,__asyncValues: __asyncValues,__makeTemplateObject: __makeTemplateObject,__importStar: __importStar,__importDefault: __importDefault};'
//const tslibCode = fs.readFileSync(__dirname + '/scripts/tslib.min.js');

// const isProd = process.env.BUILD === 'production';

export default {
	input: 'src/index.ts',
	output: [
		{
			file: "build/fyge.min.js",
			format: 'umd',
			name: 'FYGE',
			globals: {
				//tslib: 'tslib'
			},
			//banner: tslibCode + '\n' + tslibWrapper,
			sourcemap: true//!isProd,
		},
		{
			file: `build/fyge.esm.js`,
			format: 'esm',
			globals: {
				//tslib: 'tslib'
			},
			//banner: tslibCode + '\n' + tslibWrapper,
			sourcemap: true//!isProd,
		},
	],
	plugins: [
		progress(),
		resolve({}),
		typescript(),
		commonjs(),
		/*isProd &&*/ terser()
	],
	//external: ['tslib'],
};
