/**
 * 返回{ A: A, B: B }，A控制点数组，B控制点数组
 * @param points 点数组，格式[ { x: 0, y: 0 },{ x: 30, y: 0 },{ x: 30, y: -30 }],带x,y键值的对象就行
 */
export function bezierCurveControlPoint(points) {
    if (points.length > 2) {
        var A = [];
        var B = [];
        A[0] = { x: points[0].x + (points[1].x - points[0].x) / 4, y: points[0].y + (points[1].y - points[0].y) / 4 };
        B[0] = returnBControl(points, 0);
        A[points.length - 2] = returnAControl(points, points.length - 2);
        B[points.length - 2] = {
            x: points[points.length - 1].x - (points[points.length - 1].x - points[points.length - 2].x) / 4,
            y: points[points.length - 1].y - (points[points.length - 1].y - points[points.length - 2].y) / 4
        };
        for (var i = 1; i < points.length - 2; i++) {
            A[i] = returnAControl(points, i);
            B[i] = returnBControl(points, i);
        }
        return { A: A, B: B };
    }
}
function returnAControl(points, i) {
    var x = points[i].x + (points[i + 1].x - points[i - 1].x) / 4;
    var y = points[i].y + (points[i + 1].y - points[i - 1].y) / 4;
    return { x: x, y: y };
}
function returnBControl(points, i) {
    var x = points[i + 1].x - (points[i + 2].x - points[i].x) / 4;
    var y = points[i + 1].y - (points[i + 2].y - points[i].y) / 4;
    return { x: x, y: y };
}

//例子
function setPath(ctx, type) {
    var points = [
        { x: 0, y: 0 },
        { x: 30, y: 0 },
        { x: 30, y: -30 },
        { x: 60, y: -30 },
        { x: 60, y: 0 },
        { x: 90, y: 0 }];
    var AB, A, B;
    if (points.length > 2) {
        AB = bezierCurveControlPoint(points);
        A = AB.A;
        B = AB.B;
    }
    ctx.moveTo(points[0].x, points[0].y);
    for (var i = 1; i < points.length; i++) {
        if (points.length <= 2) {
            ctx.lineTo(points[i].x, points[i].y);
        } else {
            ctx.bezierCurveTo(A[i - 1].x, A[i - 1].y, B[i - 1].x, B[i - 1].y, points[i].x, points[i].y);
        }
    }
}