import { Mesh3D } from "../Mesh3D";
import { Geometry } from "../Geometry";
import { BaseMaterial } from "../materials";


export class AxesHelper extends Mesh3D {
	constructor(size: number = 1) {
		var vertices = [
			0, 0, 0, size, 0, 0,
			0, 0, 0, 0, size, 0,
			0, 0, 0, 0, 0, size
		];
		var colors = [
			1, 0, 0, 1, 0.6, 0,
			0, 1, 0, 0.6, 1, 0,
			0, 0, 1, 0, 0.6, 1
		];

		var geometry = new Geometry(vertices, null, null, colors)
		var material = new BaseMaterial({ wireframe: true,useVertexColor:true })

		super(geometry,material)
	}
}

