import { TextField } from "./TextField";
import { Event, MouseEvent } from "../events";
import { getOsType } from "../utils";
// import { osType } from "../const";


/**
 * 可编辑文本
 */
export class EditableText extends TextField {

    htmlElement: HTMLInputElement;
    private _prompt: string = "Please input";
    /**
     * 未输入文本时显示的文字
     */
    get prompt() {
        return this._prompt
    }
    set prompt(value: string) {
        if (this._prompt != value) {
            this._prompt = value;
            this["dirty"] = true;
            //如果无输入文本直接修改
            if (/*!this.htmlElement || !this.htmlElement.value*/!this._inputValue) {
                this.text = this._prompt;
            }
        }
    }
    private _promptColor: string = "#eeeeee";
    /**
     * 未输入文本时显示文字的颜色
     */
    get promptColor() {
        return this._promptColor
    }
    set promptColor(value: string) {
        if (this._promptColor != value) {
            this._promptColor = value;
            this["dirty"] = true;
            //如果无输入文本直接修改
            if (/*!this.htmlElement || !this.htmlElement.value*/!this._inputValue) {
                this.fillColor = this._promptColor;
            }
        }
    }

    private _textColor: string = "#000000";
    /**
     * 文本颜色，不用fillColor为了和父类区分
     * 输入文本时的颜色
     */
    get textColor() {
        return this._textColor
    }
    set textColor(value: string) {
        if (this._textColor != value) {
            this._textColor = value;
            this["dirty"] = true;
            //如果又文本直接修改
            if (/*this.htmlElement && this.htmlElement.value*/this._inputValue) {
                this.fillColor = this._textColor;
            }
        }
    }
    /**
     * 输入的内容
     */
    private _inputValue: string = ""
    /**
     * 获取输入框内容
     */
    get inputValue(): string {
        // return this.htmlElement && this.htmlElement.value || (this.text != this._prompt ? this.text : "")
        return this._inputValue;
    }
    set inputValue(v: string) {
        v = v || "";
        //有就加上，无碍
        if (this.htmlElement) this.htmlElement.value = v;
        //如果v不存在就用默认文案
        this.text = v ? v : this._prompt;
        //如果v不存在就用默认颜色
        this.fillColor = v ? this.textColor : this._promptColor;
        //记录一下，这个是准确的
        this._inputValue = v;
    }

    public constructor() {
        super();
        this._instanceType = "EditableText";
        var s: EditableText = this;
        var remove = function () {
            //失去焦点
            s.htmlElement && s.htmlElement.blur();
            //隐藏
            s.htmlElement.style.display = "none";
            //赋值
            if (s.htmlElement.value) {
                s.text = s.htmlElement.value;
                s.fillColor = s.textColor;
            } else {
                s.text = s.prompt;
                s.fillColor = s.promptColor;
            }
            //记录一下需要
            s._inputValue = s.htmlElement.value || "";
            window.scrollTo(0, 0)
        };

        this.addEventListener(MouseEvent.CLICK, function (e: Event) {
            s.initElement()
            //font包括字体和大小
            s.htmlElement.style.font = s.size + "px " + s.font;
            s.htmlElement.style.color = s.textColor;
            s.htmlElement.style.textAlign = s.textAlign;
            //     s.htmlElement.setAttribute("class", "inputTextFor");
            //    .inputTextFor:: -webkit - input - placeholder {
            //         text - align: center;
            //     }
            s.htmlElement.style.height = s.textHeight + "px";
            s.htmlElement.style.width = s.textWidth + "px";
            //如果文案不是默认的
            // if (s.text !== s.prompt) s.htmlElement.value = s.text;//这样判断还是可能有问题，TODO
            if (s.htmlElement.value != s._inputValue) {
                s.htmlElement.value = s._inputValue;
            }
            s.text = "";

            s.htmlElement.style.display = "block";
            s.htmlElement.selectionStart = s._inputValue.length;
            s.htmlElement.selectionEnd = s._inputValue.length;
            s.htmlElement.focus();

            let mtx = s.transform.worldMatrix;
            let d = s.stage["_dpi"] || s.stage["dpi"]//devicePixelRatio || 1;//用舞台的,能点击肯定有舞台,所以不做存在判断
            // console.log(mtx)
            //位置
            s.htmlElement.style.transform = s.htmlElement.style.webkitTransform = "matrix(" + (mtx.a / d).toFixed(4) + "," + (mtx.b / d).toFixed(4) + "," + (mtx.c / d).toFixed(4) + "," + (mtx.d / d).toFixed(4) + "," + (mtx.tx / d).toFixed(4) + "," + (mtx.ty / d).toFixed(4) + ")";

            s.stage.once(MouseEvent.MOUSE_UP, remove);
        });

    }
    private initElement() {
        let s: EditableText = this;
        if (s.htmlElement) return;
        s.htmlElement = document.createElement("input");
        let htmlElement: HTMLInputElement = s.htmlElement, style = htmlElement.style;
        htmlElement.type = "input";
        style.position = "absolute";
        style.display = "none";
        //@ts-ignore
        style.transformOrigin = style.WebkitTransformOrigin = style.webkitTransformOrigin = "0 0 0";

        style.outline = "none";
        style.borderWidth = "thin";
        style.borderColor = "#000";
        //ios得加
        style.boxSizing = "border-box";
        style.padding = "0";
        style.margin = "0";
        //默认文案
        htmlElement.placeholder = "";

        /////////////////////设置边框//////////////
        style.borderStyle = "none";
        style.backgroundColor = "transparent";
        // s.htmlElement.style.borderStyle = "inset";
        // s.htmlElement.style.backgroundColor = "#fff";

        //color:blue; text-align:center"
        // if (this.inputType == 2) {
        //     this.htmlElement.style.lineHeight = lineSpacing + "px";
        // }
        // s.stage.rootDiv.insertBefore(s.htmlElement, s.stage.rootDiv.childNodes[0]);
        //TODO到时需要修改，记录下,stage加上canvas索引，
        var divParent = s.stage["canvas"].parentNode;
        if (divParent) {
            divParent.insertBefore(htmlElement, divParent.childNodes[0])
        } else {
            document.body.appendChild(htmlElement)
        }
        //添加
        htmlElement.onblur = function (e) {
            if (getOsType() == "ios") {
                //部分app里的webview有兼容问题用window.scrollTo(0, 0)
                window.scrollTo({ top: 0, left: 0, behavior: "smooth" });
            }
            //抛出事件
            if (s.hasEventListener(Event.BLUR)) s.dispatchEvent(Event.BLUR, e)
        };
        //输入事件
        htmlElement.oninput = function (e) {
            //抛出原生的input的事件
            // if (s.hasEventListener(Event.INPUT)) s.dispatchEvent(Event.INPUT, e)
            setTimeout(function () {
                if (htmlElement.selectionStart == htmlElement.selectionEnd) {//避免中文输入法
                    s._inputValue = htmlElement.value || "";
                    if (s.hasEventListener(Event.INPUT)) s.dispatchEvent(Event.INPUT, e)
                }
            }, 0);
        }
        //聚焦事件
        htmlElement.onfocus = function (e) {
            //抛出原生的聚焦的事件
            if (s.hasEventListener(Event.FOCUS)) s.dispatchEvent(Event.FOCUS, e)
        }
        // //输入事件
        // let inputLock = false;
        // htmlElement.oninput = function (e) {
        //     if (!inputLock) {
        //         _onInput(e);
        //     }
        // };
        // htmlElement.addEventListener('compositionstart', function () {
        //     inputLock = true;
        // });
        // htmlElement.addEventListener('compositionend', function () {
        //     inputLock = false;
        //     if (!inputLock) {
        //         _onInput(e);
        //     }
        // });

        // function _onInput(e) {
        //     setTimeout(function () {
        //         if (htmlElement.selectionStart == htmlElement.selectionEnd) {
        //             s._inputValue = htmlElement.value;
        //             if (s.hasEventListener(Event.INPUT)) s.dispatchEvent(Event.INPUT, e)
        //         }
        //     }, 0);
        // }
    }

    destroy() {
        //从dom节点移除
        if (this.htmlElement && this.htmlElement.parentNode) {
            this.htmlElement.parentNode.removeChild(this.htmlElement);
            this.htmlElement = null;
        }
        super.destroy()
    }
}
