import { Mesh3D } from '../Mesh3D';
import { Box3 } from '../math/Box3';
import { Geometry } from '../Geometry';
import { BaseMaterial } from '../materials';

export class Box3Helper extends Mesh3D {
	public box: Box3
	constructor(box: Box3, color: number = 0xffff00) {
		var indices = [0, 1, 1, 2, 2, 3, 3, 0, 4, 5, 5, 6, 6, 7, 7, 4, 0, 4, 1, 5, 2, 6, 3, 7];
		var positions = [1, 1, 1, - 1, 1, 1, - 1, - 1, 1, 1, - 1, 1, 1, 1, - 1, - 1, 1, - 1, - 1, - 1, - 1, 1, - 1, - 1];
		super(new Geometry(positions, indices), new BaseMaterial({ wireframe: true, color }))
		this.box = box;
		this.mouseChildren = this.mouseEnable = false;
	}
	updateWorldMatrix(updateParents: boolean = false, updateChildren: boolean = true) {
		var box = this.box;
		if (box.isEmpty()) return;
		box.getCenter(this.position);
		box.getSize(this.scale);
		this.scale.multiplyScalar(0.5);
		super.updateWorldMatrix(updateParents, updateChildren)
	}
}
