import { HashObject } from "./HashObject";
import { AnimationClip } from "./AnimationClip";

/**
 * 用于管理传入的AnimationClips，为了多clips动画的切换
 * 不需要加入到舞台中
 * 自行加入到循环里，执行update
 * 暂时不允许多状态存在
 */
export class AnimationManager extends HashObject {
    protected currentClip: AnimationClip;
    /**
     * 传入
     * @param animationClips 所有的clip
     */
    constructor(
        private animationClips: AnimationClip[]
    ) {
        super()
        this._instanceType = "AnimationManager";
        //所有的都停下先
        this.stop();
    }
    /**
     * 获取一个AnimationClip，比如想自己控制
     * @param name
     */
    getAniClipByName(name: string) {
        for (var i = 0; i < this.animationClips.length; i++) {
            if (this.animationClips[i].name == name) return this.animationClips[i]
        }
        return null;
    }
    /**
     * 切换动画，会停止当前播放的动画
     * 精细播放自己获取并控制，这个方法只针对多clip切换
     * @param name 
     * @param loops 循环次数，0表示无限循环，默认0
     */
    showAni(name: string, loops: number = 0, callback?: () => void): AnimationClip {
        var clip = this.getAniClipByName(name)
        if (!clip) return null;
        //因为正在播放的动画会影响其他动画的初始状态，必须先重置
        if (this.currentClip) this.currentClip.resetState();
        this.currentClip = clip;
        //播放
        clip.startAniRange(0, undefined, loops, callback)
        //返回一个，可以自己玩
        return clip
    }
    /**
     * 停止
     */
    stop() {
        this.animationClips.forEach((a) => { a.stop(); })
        this.currentClip = null;
    }
    /**
     * 重置并停止
     */
    reset() {
        this.animationClips.forEach((a) => { a.resetState(); })
        this.currentClip = null;
    }
    /**
     * 循环更新方法
     * @param deltaTime 按秒计，默认0.0167
     */
    update(deltaTime: number = 0.0167) {
        for (var i = 0; i < this.animationClips.length; i++) {
            this.animationClips[i].update(deltaTime)
        }
    }
    destroy() {
        this.animationClips = null;
        this.currentClip = null;
    }
}