// var GL_MAP = {};

/**
 * 连接attribute变量与分配给它的缓冲区对象，两种方式，与顶点着色器通信核心方法
 * @param gl {WebGLRenderingContext} The current WebGL context
 * @param attribs {*}
 * @param state {*}
 */
export function setVertexAttribArrays(gl, attribs, state?) {
    var i;
    if (state) {
        var tempAttribState = state.tempAttribState,
            attribState = state.attribState;

        for (i = 0; i < tempAttribState.length; i++) {
            tempAttribState[i] = false;
        }

        // set the new attribs
        for (i = 0; i < attribs.length; i++) {
            tempAttribState[attribs[i].attribute.location] = true;
        }

        for (i = 0; i < attribState.length; i++) {
            if (attribState[i] !== tempAttribState[i]) {
                attribState[i] = tempAttribState[i];

                if (state.attribState[i]) {
                    gl.enableVertexAttribArray(i);
                }
                else {
                    gl.disableVertexAttribArray(i);
                }
            }
        }

    }
    else {
        for (i = 0; i < attribs.length; i++) {
            var attrib = attribs[i];
            gl.enableVertexAttribArray(attrib.attribute.location);
        }
    }
};