
/**
 * 批处理用buffer数据
 */
export class BatchBuffer {
    /**
     * 顶点数据,类型化数组
     * https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/ArrayBuffer
     */
    vertices: ArrayBuffer;
    /**
     * 顶点的位置信息视图，浮点数
     * View on the vertices as a Float32Array for positions
     */
    float32View: Float32Array;
    /**
     * uv及颜色值的信息视图，整数
     * View on the vertices as a Uint32Array for uvs
     */
    uint32View: Uint32Array;

    /**
     * positions,uvs,colors暂时不用做单独记录
     */
    positions: any;
    uvs: any;
    colors: any;
    /**
     * @param {number} size - The size of the buffer in bytes.
     */
    constructor(size: number) {
        this.vertices = new ArrayBuffer(size);

        this.float32View = new Float32Array(this.vertices);

        this.uint32View = new Uint32Array(this.vertices);
    }

    /**
     * Destroys the buffer.
     *
     */
    public destroy() {
        this.vertices = null;
        this.float32View = null;
        this.uint32View = null;
        this.positions = null;
        this.uvs = null;
        this.colors = null;
    }
}
