
let env: "tb" | "web" | "tt" = "web";
//如果是浏览器环境，声明个my为null，为了无声明不报错
if (window) window["my"] = null;//在用webview的小程序环境内，只要在小程序的sdk前加js就无所谓，
export function getEnv(): "tb" | "web" | "tt" {
    return env
}
/**
 * 设置运行环境，一般不需要调用，预留
 * 方法initedByTbCanvas会自行设置env为tb
 * @param e 环境
 */
export function setEnv(e: "tb" | "web" | "tt") {
    env = e;
}
/**
 * 创建一个离屏的canvas
 */
export function createCanvas(): HTMLCanvasElement {
    //@ts-ignore  先这么改把，以后再改TODO，Texture.WHITE有个自执行，所以在setEnv前就会执行web的链路，以后考虑兼容document
    // return document && document.createElement("canvas") || createTbOffscreenCanvas()//my._createOffscreenCanvas();
    //web环境
    if (getEnv() == "web") return document.createElement("canvas");
    //淘宝小程序环境
    if (getEnv() == "tb") return createTbOffscreenCanvas()//my._createOffscreenCanvas();
    //tt环境，TODO
    if (getEnv() == "tt") {
        console.error("tt环境待开发")
        return
    }
    //提示下
    console.warn("未知环境，创建canvas失败")
}
function createTbOffscreenCanvas() {
    //@ts-ignore
    var tbMy = my;
    if (!tbMy) return null;
    //不带_的先试试
    if (tbMy.createOffscreenCanvas) {
        //先试试不加参数是否有返回，再用加参数的，淘宝小部件2.0的好像必须加参数，否则返回空的
        return tbMy.createOffscreenCanvas() || tbMy.createOffscreenCanvas(3, 3);
    }
    //再用带_的
    return tbMy._createOffscreenCanvas() || tbMy._createOffscreenCanvas(3, 3);
}
/**
 * 临时记录的淘宝小程序的主canvas
 */
let tbCanvas;
/**
 * 淘宝小程序项目，拿到canvas先执行这个,修改当前环境
 * @param canvas 
 */
export function initedByTbCanvas(canvas) {
    tbCanvas = canvas;
    setEnv("tb");
}
/**
 * 预留方法，后续开发，主要用于初始化Canvas类和Image类，TODO
 */
export function initedByTtEnv() {
    console.log("待开发")
    setEnv("tt")
}
//兼容老版本，TODO废弃
export function initedByCanvas(canvas) {
    console.warn("方法initedByCanvas即将废弃，请使用方法initedByTbCanvas代替")
    initedByTbCanvas(canvas)
}
/**
 * 销毁记录的tbCanvas，一般也没必要执行，
 * 尤其多页面的淘宝小程序，销毁的话，createImage会有问题
 */
export function destroyTbCanvas() {
    tbCanvas = null;
}
//兼容老版本，TODO废弃
export function destroyCanvasContent() {
    console.warn("方法destroyCanvasContent即将废弃，请使用方法destroyTbCanvas代替")
    destroyTbCanvas();
}

/**
 * 返回图片
 * @returns 
 */
export function createImage(): HTMLImageElement {
    if (getEnv() == "web") return new Image();
    if (getEnv() == "tb") {
        if (tbCanvas) return tbCanvas.createImage();
        console.warn("淘宝小程序初始化canvas不存在");
    }
    //tt环境，TODO
    if (getEnv() == "tt") {
        console.error("tt环境待开发")
        return
    }
    console.warn("未知环境，创建Image失败")
}
/**
 * 尽量外部自行调用循环，不用引擎给的，即将废弃
 * @param callback 
 * @returns 
 */
export function requestAnimationFrame(callback) {
    //直接用window的
    if (getEnv() == "web") return window.requestAnimationFrame(callback);
    //淘宝小程序环境
    if (getEnv() == "tb") {
        if (tbCanvas) return tbCanvas.requestAnimationFrame(callback);
        console.warn("淘宝小程序初始化canvas不存在");
    }
    //tt环境，待测试，js运行环境可能默认有，TODO
    if (getEnv() == "tt") return requestAnimationFrame(callback);

    console.warn("未知环境，requestAnimationFrame调用无效")
}
export function cancelAnimationFrame(id: number) {
    if (getEnv() == "web") {
        window.cancelAnimationFrame(id);
        return;
    }
    //淘宝小程序环境
    else if (getEnv() == "tb") {
        if (tbCanvas) {
            tbCanvas.cancelAnimationFrame(id);
            return;
        }
        console.warn("淘宝小程序初始化canvas不存在");
    }
    //tt环境，待测试，js运行环境可能默认有，TODO
    else if (getEnv() == "tt") {
        cancelAnimationFrame(id);
        return;
    }
    console.warn("未知环境，cancelAnimationFrame调用无效")
}

//老版本使用提示，TODO废弃
export function getRequestAnimationFrame() {
    console.error("requestAnimationFrame,cancelAnimationFrame统统外部自行调用，引擎内不给方法，淘宝小程序在canvas上，web环境在window上")
}

let webglSupported: boolean;
/**
 * 判断是否支持webgl
 * @function isWebGLSupported
 * @return {boolean}
 */
export function isWebGLSupported(): boolean {
    //淘宝环境直接返回true，否则找淘宝小程序解决，tt环境待测试，TODO
    if (getEnv() == "tb" || getEnv() == "tt") return true;
    //已经判断过了，直接返回
    if (webglSupported !== undefined) return webglSupported;
    //进入判断，加上低性能下是否使用webgl标识，pc上因为failIfMajorPerformanceCaveat设为true获取不到webgl一般是驱动问题
    const contextOptions = { stencil: true, failIfMajorPerformanceCaveat: true };
    try {
        if (!window["WebGLRenderingContext"]) {
            return false;
        }
        const canvas = createCanvas()// document.createElement('canvas');
        let gl = canvas.getContext('webgl', contextOptions) || canvas.getContext('experimental-webgl', contextOptions);
        const success = !!(gl && gl["getContextAttributes"]().stencil);
        if (gl) {
            const loseContext = gl["getExtension"]('WEBGL_lose_context');
            if (loseContext) {
                loseContext.loseContext();
            }
        }
        gl = null;
        return webglSupported = success;
    }
    catch (e) {
        return webglSupported = false;
    }
}
//缓存的操作系统类型
let osType: "ios" | "android" | "pc";
/**
 * 获取操作系统类型，"ios" | "android" | "pc";
 * @returns 
 */
export function getOsType(): "ios" | "android" | "pc" {
    //有就直接返回
    if (osType) return osType;
    if (getEnv() == "web") {
        osType = navigator && navigator.userAgent && (function () {
            let n = navigator.userAgent.toLocaleLowerCase();
            let reg1 = /android/;
            let reg2 = /iphone|ipod|ipad/;
            if (reg1.test(n)) {
                return "android";
            } else if (reg2.test(n)) {
                return "ios"
            } else {
                return "pc";
            }
        })() || null;
        //@ts-ignore 如果没取到，有可能环境还没切换，直接用老方法获取，或者直接给个提示
        if (!osType && my) osType = my.getSystemInfoSync().platform.toLowerCase();
        //tt的再来一次，TODO
        // if(!osType&&)
    }
    else if (getEnv() == "tb") {
        //@ts-ignore
        osType = my.getSystemInfoSync().platform.toLowerCase();
    }
    //tt环境待开发，TODO
    else if (getEnv() == "tt") {
        console.error("tt环境待开发")
    }
    else {
        console.warn("未知环境，获取失败")
    }
    return osType;
}

let devicePixelRatio: number;
/**
 * 获取屏幕像素比dpr
 * @returns 
 */
export function getDevicePixelRatio() {
    if (devicePixelRatio) return devicePixelRatio;
    if (getEnv() == "web") {
        devicePixelRatio = window && (window.devicePixelRatio || 1);
        //@ts-ignore如果还没取到，环境切换有问题，用老方法
        if (!devicePixelRatio && my) devicePixelRatio = my.getSystemInfoSync().pixelRatio;
        //tt的再来一个，TODO
        // if(!devicePixelRatio&&)
    }
    else if (getEnv() == "tb") {
        //@ts-ignore
        devicePixelRatio = my.getSystemInfoSync().pixelRatio;
    }
    //tt环境待开发，TODO
    else if (getEnv() == "tt") {
        console.error("tt环境待开发")
    }
    else {
        console.warn("未知环境，获取失败")
    }
    return devicePixelRatio;
}
