/**
 * 基础对象，用于标记类名及唯一实例id
 * 只在引擎内部使用
 */
export abstract class HashObject {
    protected _instanceId: number = 0;
    protected _instanceType: string = "HashObject";
    protected static _object_id = 0;

    constructor() {
        this._instanceId = HashObject._object_id++;
    }

    /**
     * 每一个对象都会有一个唯一的id码。
     * @property instanceId
     * @public
     * @since 1.0.0
     * @return {number}
     * @readonly
     * @example
     *      //获取 对象唯一码
     *      console.log(this.instanceId);
     */
    public get instanceId(): number {
        return this._instanceId;
    }

    /**
     * 每一个类都有一个实例类型字符串，通过这个字符串，你能知道这个实例是从哪个类实例而来
     * @property instanceType
     * @since 1.0.0
     * @public
     * @return {string}
     * @readonly
     */
    public get instanceType(): string {
        return this._instanceType;
    }

    /**
     * 抽象方法，销毁一个对象，子类写
     * @method destroy
     * @since 1.0.0
     * @public
     * @return {void}
     */
    abstract destroy(): void;
}
