import { HashObject } from "../../2d/HashObject";
import RenderTexture from "../../2d/texture/RenderTexture";
import { Camera } from "../cameras/Camera";
import { Matrix4 } from "../math/Matrix4";
import { Vector2 } from "../math/Vector2";


export class LightShadow extends HashObject {
	public bias: number = 0;
	public radius: number = 1;
	public mapSize = new Vector2(512, 512);
	public map: RenderTexture;
	public matrix: Matrix4 = new Matrix4();
	constructor(public camera?: Camera) {
		super();
		this._instanceType = "LightShadow";
	}
	copy(source: LightShadow) {
		this.camera = source.camera.clone();

		this.bias = source.bias;
		this.radius = source.radius;

		this.mapSize.copy(source.mapSize);

		return this;
	}
	/**
	 * 子类继承修改为自己的
	 * @param source 
	 */
	clone() {
		return new LightShadow().copy(this);
	}
	destroy() {
		this.mapSize = null;
		this.camera.destroy();
		this.camera = null
	}
}
