import Container from "../display/Container";
import Sprite from "../display/Sprite";
import { Event } from "../events/Event";
import { MouseEvent } from "../events/MouseEvent";
import Texture from "../texture/Texture";
import Tween from "../../tween/Tween";

let hasWarned: boolean;
export class Button extends Sprite {
    private textureUp: Texture;
    private textureDown: Texture;
    private textureDisable: Texture;
    constructor(tUp: Texture, tDown?: Texture, tDisable?: Texture) {
        super(tUp);
        if (!hasWarned) console.warn(`Class Button will be abandoned later,maybe you can:
function addClickZoom(dis: DisplayObject, zoomCenter: boolean = true) {
    if (zoomCenter) {
        dis.anchorX = dis.width / 2;
        dis.anchorY = dis.height / 2;
    }
    dis.addEventListener("onMouseDown", _mouseEvent, dis)
        .addEventListener("onMouseUp", _mouseEvent, dis)
        .addEventListener("onMouseOut", _mouseEvent, dis);
    let s = dis;
    function _mouseEvent(e: MouseEvent) {
        if (e.type == MouseEvent.MOUSE_DOWN) {
            Tween.removeTweens(s);
            Tween.get(s).to({ scaleX: 0.9, scaleY: 0.9 }, 50);
        } else {
            Tween.removeTweens(s);
            Tween.get(s).to({ scaleX: 1, scaleY: 1 }, 50);
        }
    }
}`)
        hasWarned = true;

        this._instanceType = "Button";

        this.textureUp = tUp;
        this.textureDown = tDown === tUp ? null : tDown;
        this.textureDisable = tDisable || tUp;

        //直接设置纹理的中心点为锚点，传入有纹理才设置，以防止报错
        if (this.textureUp) {
            this.anchorX = this.textureUp.width / 2;
            this.anchorY = this.textureUp.height / 2;
        }
        this.initButton();
    }
    /**
     * 修改纹理
     * @param tUp 
     * @param tDown 
     * @param tDisable 
     */
    changeTexture(tUp: Texture, tDown?: Texture, tDisable?: Texture) {
        this.textureUp = tUp;
        this.textureDown = tDown === tUp ? null : tDown;
        this.textureDisable = tDisable || tUp;

        if (this.textureUp) {//传入有纹理才设置，以防止报错
            this.anchorX = this.textureUp.width / 2;
            this.anchorY = this.textureUp.height / 2;
        }
        //如果是点击状态时且有down
        if (this._clicked && this.textureDown) {
            this.texture = this.textureDown;
        }
        //禁用状态时
        else if (!this.mouseEnable && !this.textureStatusEnable) {
            this.texture = this.textureDisable;
        } else {
            this.texture = this.textureUp;
        }
    }

    /**
     * @method  _mouseEvent
     * @param e
     * @private
     */
    private _mouseEvent(e: any): void {
        let s = this;
        if (!s._clicked) {
            if (e.type == MouseEvent.MOUSE_DOWN) {
                //如果是点下
                if (s.textureDown) {
                    s.texture = s.textureDown
                } else {
                    this["frames"] = null
                    // s.scale.x = s.scale.y = 0.9
                    Tween.removeTweens(this);
                    Tween.get(this).to({ scaleX: 0.9, scaleY: 0.9 }, 50);
                }
            } else {
                if (s.textureDown) {
                    s.texture = s.textureUp
                } else {
                    this["frames"] = this["framesOri"]
                    // s.scale.x = s.scale.y = 1
                    Tween.removeTweens(this);
                    Tween.get(this).to({ scaleX: 1, scaleY: 1 }, 50);
                }
            }
        }
    };

    public initButton(): void {
        let s: any = this;
        s.mouseChildren = false;
        s.addEventListener("onMouseDown", s._mouseEvent, s);
        s.addEventListener("onMouseUp", s._mouseEvent, s);
        s.addEventListener("onMouseOut", s._mouseEvent, s);
        s.texture = s.textureUp
    }

    /**
     * 设置是否为点击状态
     * @property clicked
     * @param {boolean} value
     * @public
     * @since 2.0.0
     * @default false
     */
    public set clicked(value: boolean) {
        let s = this;
        if (value != s._clicked) {
            if (value) {
                s._mouseEvent({ type: "onMouseDown" });
            }
            s._clicked = value;
        }
    }

    public get clicked(): boolean {
        return this._clicked;
    }

    private _clicked = false;

    //设置texture状态textureUp和textureDisable
    set textureStatusEnable(value: boolean) {
        if (value) {
            this.texture = this.textureUp
        } else {
            if (this.textureDisable) {
                this.texture = this.textureDisable;
                this["frames"] = null
            }
        }
    }

    set enabled(value: boolean) {
        this.mouseEnable = value;
        this.textureStatusEnable = value;
    }

    destroy() {
        this.textureUp = null;
        this.textureDown = null;
        this.textureDisable = null;
        Tween.removeTweens(this);
        super.destroy();
    }
}