import { HashObject } from "../../2d/HashObject";
import { Texture } from "../../2d/texture";
import { Vector3 } from "../math/Vector3";
import { hex2rgb } from "../../2d/utils";

export enum RenderSideType {
    /**
     * 正面才渲染，逆时针顶点
     */
    FrontSide = 0,
    /**
     * 反面才渲染，顺时针顶点顺序
     */
    BackSide,
    /**
     * 两面都渲染
     */
    DoubleSide,
}

/**
 * 材质基类，一些基本属性加上
 */
export class BaseMaterial extends HashObject {

    /**
     * 十六进制 hex2rgb ,转成0到1的数组
     */
    private _color: number = 0xffffff;
    private _colorArr: Float32Array = new Float32Array([1.0, 1.0, 1.0]);
    get color() {
        return this._color;
    }
    set color(value: number) {
        if (this._color === value) return;
        this._color = value;
        var arr = hex2rgb(value)
        this._colorArr[0] = arr[0];
        this._colorArr[1] = arr[1];
        this._colorArr[2] = arr[2];
    }
    //获取
    get colorArr() {
        return this._colorArr;
    }

    /**
     * 透明度0到1
     */
    alpha: number = 1
    /**
     * 纹理贴图，默认白图
     */
    private _map: Texture = Texture.WHITE;
    get map() {
        return this._map
    }
    set map(value: Texture) {
        this._map = value || Texture.WHITE;
    }
    morphTargets: boolean = false;
    morphNormals: boolean = false;
    /**
     * 是否用线框形式绘制
     */
    wireframe: boolean = false;

    side: RenderSideType = RenderSideType.FrontSide;
    /**
     * 是否光照影响
     */
    _lightAffect: boolean = false;
    constructor(parameters?: BaseMaterialParamsInt) {
        super();
        this._instanceType = "BaseMaterial";

        //所有属性
        if (parameters) {
            for (var key in parameters) {
                this[key] = parameters[key];
            }
        }
    }
    destroy() {
        this._color = null;
    }
}

interface BaseMaterialParamsInt {
    color?: number,
    alpha?: number,
    map?: Texture,
    wireframe?: boolean
}