

import { TEXT_ALIGN, VERTICAL_ALIGN } from "../const";
import Texture from "../texture/Texture";
import { Sprite, Container } from "../display";

/**
 * 单位图字缓存
 */
const bitmapTextSinglePool: BitmapTextSingle[] = []

/**
 * 位图文字
 * 暂不做通用，以后再说，否则回收问题
 */
export class BitmapText extends Container {
    private textures: { [text: string]: Texture }
    /**
     * 对齐方式
     */
    textAlign: TEXT_ALIGN = TEXT_ALIGN.CENTER;
    /**
     * 垂直居中方式，暂时还没写,
     */
    verticalAlign: VERTICAL_ALIGN = VERTICAL_ALIGN.MIDDLE;
    /**
     * 文本
     */
    private _text: string;
    get text(): string {
        return this._text
    }
    /**
     * 设置文本
     */
    set text(value: string) {
        if (value === this._text) return;
        this._text = value;
        var arr = value || [];
        //
        for (var i = 0; i < arr.length; i++) {
            if (this.children[i]) {
                //先用完原先$children里的
                this.children[i]["text"] = arr[i];
            } else {
                //如果没有就
                let o: BitmapTextSingle = bitmapTextSinglePool.shift();
                if (!o) {
                    o = new BitmapTextSingle(this.textures);
                } else {
                    o.reset(this.textures)
                }
                o.text = arr[i];
                this.addChild(o)
            }
        }
        //如果多了，去掉后面的，回收
        if (this.children.length > arr.length) {
            //移除后序
            for (var i = this.children.length - 1; i >= arr.length; i--) {
                let c = this.children[i];
                this.removeChild(c);
                bitmapTextSinglePool.push(c);
            }
        }
        //适配
        this.adaptate()
    }
    /**
     * 
     * @param textures 0到9的贴图
     */
    constructor(textures: { [text: string]: Texture }) {
        super();
        this.textures = textures;
    }

    /**
     * 适配，暂时只有水平居中的适配，垂直的尽量让图片控制一致
     */
    adaptate() {
        if (!this.children.length) return
        var len = this.children.length;
        //算总长度
        var sum = 0;
        for (var m = 0; m < len; m++) {
            sum += this.children[m].width;
        }
        //算出左边第一个元素的位置
        var left = -sum / 2;
        if (this.textAlign == TEXT_ALIGN.LEFT) {
            left = 0
        }
        else if (this.textAlign == TEXT_ALIGN.RIGHT) {
            left = sum
        }
        var temSum = 0;
        for (var i = 0; i < this.children.length; i++) {
            this.children[i].x = left + temSum
            temSum += this.children[i].width;
        }
        //垂直居中，暂时还没写
    }
}


/**
 * 位图字，单个
 */
class BitmapTextSingle extends Sprite {
    /**
     * 文字表
     */
    private textures: {
        [text: string]: Texture
    };
    /**
     * 单字
     */
    private _text: string;
    get text(): string {
        return this._text
    }
    set text(value: string) {
        // if (value == this._text) return;
        this._text = value;
        this.texture = this.textures[this._text];
    }

    /**
     * 
     * @param textures 贴图表，{"0":texture1,"1":texture2,".":texture3}
     */
    constructor(textures: { [text: string]: Texture }) {
        super();
        this.textures = textures;
    }

    /**
     * 替换资源，基本不用吧应该
     * @param textures 
     */
    reset(textures: { [text: string]: Texture }) {
        this.textures = textures
    }
}