
export function createCanvas(): HTMLCanvasElement {
    //@ts-ignore
    return document && document.createElement("canvas") || my._createOffscreenCanvas();
}

let contentByCanvas: {
    createImage: () => HTMLImageElement,
    requestAnimationFrame: (fun: Function) => number,
    cancelAnimationFrame: (id) => void,
};
export function initedByCanvas(canvas) {
    contentByCanvas = {
        createImage: canvas.createImage.bind(canvas),
        //必须加bind，函数内存在this指向
        requestAnimationFrame: canvas.requestAnimationFrame.bind(canvas),
        cancelAnimationFrame: canvas.cancelAnimationFrame.bind(canvas),
    }
}
export function destroyCanvasContent() {
    if (contentByCanvas) {
        contentByCanvas.createImage = null;
        contentByCanvas.requestAnimationFrame = null;
        contentByCanvas.cancelAnimationFrame = null;
        contentByCanvas = null
    }
}

export function getCreateImage() {
    return contentByCanvas && contentByCanvas.createImage || (() => { return new Image() })
}
export function getRequestAnimationFrame() {
    return contentByCanvas && contentByCanvas.requestAnimationFrame || window.requestAnimationFrame.bind(window)
}
export function getCancelAnimationFrame() {
    return contentByCanvas && contentByCanvas.cancelAnimationFrame || window.cancelAnimationFrame.bind(window)
}
