import { HashObject } from "../../2d/HashObject";
import { Object3D } from "../Object3D";
import { Mesh3D } from "../Mesh3D";

/**
 * 动画类型
 */
export enum AnimationType {
    /**
     * 旋转
     */
    quaternion = "quaternion",
    /**
     * 缩放
     */
    scale = "scale",
    /**
     * 顶点权重
     */
    morphTargetInfluences = 'morphTargetInfluences',
    /**
     * 位移
     */
    position = "position"
}
/**
 * 记录动画的轨迹，实时计算，还是用每帧的，暂时按时间间隔来搞，实时计算吧
 * 统统用线性的吧
 */
export class AnimationTrack extends HashObject {
    /**
     * 需要改变属性的节点对象
     */
    node: Object3D | Mesh3D
    /**
     * 动画类型
     */
    animationType: AnimationType
    /**
     * 记录所有时间的数组，按顺序递增，没有的按最后一个时间的数据
     */
    times: Float32Array | number[];
    /**
     * 上述时间要对应的数值，values.length/times.length就是步长
     */
    values: Float32Array | number[];
    constructor() {
        super()
        this._instanceType = "AnimationTrack";

    }
    destroy() {

    }
}